module.exports = {
    'name': 'Pivot Table',
    'icon': require('images/pivot.svg'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'infinite-viz'
        ]
    },
    'required': {
        'PY': []
    },
    'content': {
        'template': {
            'name': 'view-loader'
        }
    },
    'visualization': {
        'type': [
            'echarts',
            'standard'
        ],
        'group': 'Other',
        'view': 'visualization',
        'layout': 'PivotTable',
        'visibleModes': [
            'default-mode'
        ],
        'tools': [
		  'filter',
            'unfilter',
            'events',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'format': 'pivot',
        'fields': [{
            'model': 'rows',
            'name': 'Rows',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': true,
            'description': 'One or more dimensions to be plotted on the rows of the pivot table.'
        },
        {
            'model': 'columns',
            'name': 'Columns',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': true,
            'description': 'One or more dimensions to be plotted on the column of the pivot table.'
        },
        {
            'model': 'calculations',
            'name': 'Calculations',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': true,
            'description': 'One or more summary calculations to use to calculate the values of the cells in the pivot table.'
        }]
    },
    'lazy': true
};
