module.exports = {
    'name': 'ParallelCoordinates',
    'icon': require('images/parallel-coordinates-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter'
        ]
    },
    'content': {
        'template': {
            'name': 'parallel-coordinates-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'ParallelCoordinates',
        'visibleModes': [
            'default-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'fit-horizontal',
            'fit-vertical',
            'parcoords-add-filter',
            'parcoords-clear-filter',
            'parcoords-add-count',
            'toggle-canvas',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'dimension',
                'name': 'Dimension',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': false,
                'optional': false,
                'multiField': true,
                'description': 'Try adding two or more dimensions (i.e. Movie Budget and Revenue). Each dimension will represent a vertical line.'
            }
        ],
        'color': {}
    },
    'tools': {
        'widthFitToScreen': false,
        'heightFitToScreen': false
    },
    'state': {
        'overlapRelated': ''
    },
    'lazy': true
};
