enum TEMPLATE_VALUES {
    SINGLE= 'SINGLE',
    MULTIPLE= 'MULTIPLE'
};
enum SUGGESTION_TYPE {
    TEMPLATE = 'template',
    SUBCOMPONENT = 'subcomponent'
};
enum TEMPLATE_TYPE {
    SELECT = 'select column',
    AVERAGE = 'average column',
    COUNT = 'count column',
    MAX = 'max column',
    MIN = 'min column',
    SUM = 'sum column',
    UNIQUE_COUNT = 'unique column count',
    STANDARD_DEVIATION = 'stdev column',
    GROUP = 'group column',
    WHERE = 'where column is value',
    HAVING_AVERAGE = 'having average column is value',
    HAVING_COUNT = 'having count column is value',
    HAVING_MAX = 'having max column is value',
    HAVING_MIN = 'having min column is value',
    HAVING_SUM = 'having sum column is value',
    RANK_TOP = 'rank column top',
    RANK_TOP_N = 'rank column top n',
    RANK_BOTTOM = 'rank column bottom',
    RANK_BOTTOM_N = 'rank column bottom n',
    SORT_ASC = 'sort column ascending',
    SORT_DESC = 'sort column descending'
};
const AGGREGATES :string[] = [
    TEMPLATE_TYPE.AVERAGE,
    TEMPLATE_TYPE.COUNT,
    TEMPLATE_TYPE.MAX,
    TEMPLATE_TYPE.MIN,
    TEMPLATE_TYPE.SUM,
    TEMPLATE_TYPE.UNIQUE_COUNT,
    TEMPLATE_TYPE.STANDARD_DEVIATION
]
const TEMPLATES :any = {
    [TEMPLATE_TYPE.SELECT]: {
        column: TEMPLATE_VALUES.MULTIPLE,
        query: 'select',
        required: ['column']
    },
    [TEMPLATE_TYPE.AVERAGE]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'average',
        required: ['column']
    },
    [TEMPLATE_TYPE.COUNT]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'count',
        required: ['column']
    },
    [TEMPLATE_TYPE.MAX]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'max',
        required: ['column']
    },
    [TEMPLATE_TYPE.MIN]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'min',
        required: ['column']
    },
    [TEMPLATE_TYPE.SUM]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'sum',
        required: ['column']
    },
    [TEMPLATE_TYPE.UNIQUE_COUNT]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'unique count',
        required: ['column']
    },
    [TEMPLATE_TYPE.STANDARD_DEVIATION]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'stdev',
        required: ['column']
    },
    [TEMPLATE_TYPE.GROUP]: {
        column: TEMPLATE_VALUES.MULTIPLE,
        query: 'group',
        required: ['column']
    },
    [TEMPLATE_TYPE.WHERE]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'where',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.HAVING_AVERAGE]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'having average',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.HAVING_COUNT]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'having count',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.HAVING_MAX]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'having max',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.HAVING_MIN]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'having min',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.HAVING_SUM]: {
        column: TEMPLATE_VALUES.SINGLE,
        operation: TEMPLATE_VALUES.SINGLE,
        value: TEMPLATE_VALUES.MULTIPLE,
        query: 'having sum',
        required: ['column', 'operation', 'value']
    },
    [TEMPLATE_TYPE.RANK_TOP]: {
        column: TEMPLATE_VALUES.SINGLE,
        static_operation: 'top',
        static_value: "1",
        query: 'rank',
        required: ['column']
    },
    [TEMPLATE_TYPE.RANK_TOP_N]: {
        column: TEMPLATE_VALUES.SINGLE,
        static_operation: 'top',
        value: TEMPLATE_VALUES.SINGLE,
        query: 'rank',
        required: ['column', 'value']
    },
    [TEMPLATE_TYPE.RANK_BOTTOM]: {
        column: TEMPLATE_VALUES.SINGLE,
        static_operation: 'bottom',
        static_value: "1",
        query: 'rank',
        required: ['column']
    },
    [TEMPLATE_TYPE.RANK_BOTTOM_N]: {
        column: TEMPLATE_VALUES.SINGLE,
        static_operation: 'bottom',
        value: TEMPLATE_VALUES.SINGLE,
        query: 'rank',
        required: ['column', 'value']
    },
    [TEMPLATE_TYPE.SORT_ASC]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'sort',
        static_operation: 'ascending',
        required: ['column']
    },
    [TEMPLATE_TYPE.SORT_DESC]: {
        column: TEMPLATE_VALUES.SINGLE,
        query: 'sort',
        static_operation: 'descending',
        required: ['column']
    }
};

export {
    TEMPLATE_VALUES,
    SUGGESTION_TYPE,
    TEMPLATE_TYPE,
    AGGREGATES,
    TEMPLATES
}