module.exports = {
    'name': 'Map',
    'icon': require('images/map-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'map-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Map',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'display-values',
            'color-by-value',
            'map-color-theme',
            'facet-headers',
            'toggle-tooltips',
            'toggle-svg',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'Label',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multifield': false,
                'description': 'Try adding one dimension (i.e. City Name). Each instnace of this dimension will represent a point on the map.'
            },
            {
                'model': 'latitude',
                'name': 'Latitude',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER'
                ],
                'group': 'validate',
                'optional': false,
                'multifield': false,
                'description': 'Each instance of the label dimension needs to be accompanied by a latitude and longitude to appear on the map.'
            },
            {
                'model': 'longitude',
                'name': 'Longitude',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Each instance of the label dimension needs to be accompanied by a latitude and longitude to appear on the map.'
            },
            {
                'model': 'size',
                'name': 'Size',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one numerical dimension (i.e. City Population). This will represent the size of each point on the map.'
            },
            {
                'model': 'color',
                'name': 'Color',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Political Alignment). Each instance within this dimension will represent a color.'
            },
            {
                'model': 'facet',
                'name': 'Facet',
                'acceptableTypes': [
                    'STRING',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': false,
                'description': 'Try adding one dimension (i.e. Political Alignment). The data will be grouped by each instance of the selected dimension.'
            },
            {
                'model': 'tooltip',
                'name': 'Tooltip',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Average Income). Each instance of this dimension will appear in the tooltip when hovering.'
            }
        ],
        'color': {}
    },
    'tools': {
        'colorByValue': false
    },
    'lazy': true
};
