module.exports = {
    'name': 'Generate Lookup',
    'description': 'Generate a table to lookup values that can be later matched and merged.',
    'icon': require('images/add-table.svg'),
    'widgetList': {
        'showOn': 'none'
    },
    'required': {
        'R': [],
        'Frame': ['R']
    },
    'content': {
        'template': {
            'name': 'lookup-generate'
        }
    },
    'pipeline': {
        'group': 'Destination',
        'input': [
            'FRAME'
        ],
        'parameters': {
            'FRAME': {
                'frame': true
            },
            'COLUMN': {
                'type': 'PIXEL'
            },
            'FILE': {
                'type': 'PIXEL'
            }
        },
        'pixel': '<FRAME.name> | LookupGenerate(column=["<COLUMN>"], fileName=["<FILE.path>"], space=["<FILE.space>"]);'
    },
    'lazy': true
};