module.exports = {
    'name': 'Line',
    'icon': require('images/line-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'flip-axis',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'line-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Line',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'color-panel',
            'color-by-value',
            'display-values',
            'flip-axis',
            'flip-series',
            'format-data-values',
            'line-curve-type',
            'sort-values',
            'toggle-legend',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [
            {
                'model': 'label',
                'name': 'X-Axis',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'validate',
                'optional': false,
                'multiField': false,
                'description': 'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.'
            },
            {
                'model': 'value',
                'name': 'Y-Axis',
                'acceptableTypes': [
                    'NUMBER'
                ],
                'group': 'math',
                'optional': false,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Movie Budget). Each dimension will represent a line.'
            },
            {
                'model': 'series',
                'name': 'Series',
                'acceptableTypes': [
                    'NUMBER',
                    'STRING',
                    'DATE'
                ],
                'group': 'validate',
                'optional': true,
                'multiField': false,
                'description': ' '
            },
            {
                'model': 'tooltip',
                'name': 'Tooltip',
                'acceptableTypes': [
                    'STRING',
                    'NUMBER',
                    'DATE'
                ],
                'group': 'concat',
                'optional': true,
                'multiField': true,
                'description': 'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.'
            }
        ],
        'color': {
            'value': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'lazy': true
};
