'use strict';

export default angular.module('app.fit-vertical.directive', [])
    .directive('fitVertical', fitVertical);

fitVertical.$inject = [];

function fitVertical() {
    fitVerticalLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        restrict: 'EA',
        scope: {},
        require: ['^widget'],
        link: fitVerticalLink
    };

    function fitVerticalLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            scope.widgetCtrl.emit('update-tool', {
                'fn': 'heightFitToScreen',
                'args': ['', '', 0]
            });
        }

        initialize();
    }
}