module.exports = {
    'name': 'Filter',
    'description': 'Add or remove filters your data',
    'icon': require('images/filter.svg'),
    'widgetList': {
        'showOn': [
            'Visualization'
        ]
    },
    'content': {
        'template': {
            'name': 'filter'
        }
    },
    'pipeline': {
        'group': 'Transform',
        'parameters': {
            'FRAME': {
                'frame': true
            },
            'OPERATION': {
                'type': 'PIXEL'
            },
            'FILTERS': {
                'type': 'FILTERS'
            }
        },
        'input': [
            'FRAME'
        ],
        'pixel': '<FRAME.name> | <OPERATION>(<FILTERS>);'
    },
    'lazy': true
};
