'use strict';

import './export-dashboard.scss';

export default angular.module('app.export-dashboard.directive', [])
    .directive('exportDashboard', exportDashboardDirective);

exportDashboardDirective.$inject = [];

function exportDashboardDirective() {
    exportDashboardCtrl.$inject = [];
    exportDashboardLink.$inject = ['scope', 'ele', 'attrs', 'ctrl'];

    return {
        restrict: 'EA',
        template: require('./export-dashboard.directive.html'),
        scope: {},
        require: ['^widget', '?^pipelineComponent'],
        controllerAs: 'exportDashboard',
        bindToController: {},
        controller: exportDashboardCtrl,
        link: exportDashboardLink
    };

    function exportDashboardCtrl() {}

    function exportDashboardLink(scope, ele, attrs, ctrl) {
        scope.widgetCtrl = ctrl[0];
        scope.pipelineComponentCtrl = ctrl[1];

        scope.exportDashboard.PIPELINE = scope.pipelineComponentCtrl !== null;

        scope.exportDashboard.closeExport = closeExport;
        scope.exportDashboard.runExport = runExport;
        scope.exportDashboard.types = {
            selected: 'ExportToExcel',
            list: [
                {
                    display: 'Excel',
                    value: 'ExportToExcel'
                },
                {
                    display: 'Powerpoint',
                    value: 'ExportToPPT'
                }
            ]
        };

        /**
         * @name closeExport
         * @desc close the exportDashboard when the pipeline is closed
         * @returns {void}
         */
        function closeExport() {
            if (scope.exportDashboard.PIPELINE) {
                scope.pipelineComponentCtrl.closeComponent();
            }
        }

        /**
         * @name runExport
         * @desc export to the selected export type
         * @returns {void}
         */
        function runExport() {
            var parameters,
                pixel = '';

            parameters = buildParameters();

            if (scope.exportDashboard.PIPELINE) {
                scope.pipelineComponentCtrl.executeComponent(parameters, {
                    name: 'Export Dashboard'
                });
                return;
            }

            pixel += `${parameters.OPERATION};`;

            scope.widgetCtrl.execute([{
                type: 'Pixel',
                components: [
                    pixel
                ],
                terminal: true
            }]);
        }

        /**
         * @name buildParameters
         * @desc build the parameters for the current module
         * @returns {object} - map of the paramters to value
         */
        function buildParameters() {
            var selectedType = scope.exportDashboard.types.selected + '()';

            return {
                'OPERATION': selectedType
            };
        }


        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
        }

        initialize();
    }
}