module.exports = {
    'name': 'Dendrogram',
    'icon': require('images/dendrogram-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'toggle-dendrogram-labels',
            'fit-to-view',
            'toggle-radial',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'dendrogram-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Dendrogram',
        'visibleModes': [
            'default-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'change-symbol-dendrogram',
            'font-settings',
            'color-scheme',
            'color-by-value',
            'edit-tree-depth',
            'fit-to-view',
            'flip-axis',
            'sort-values',
            'toggle-legend',
            'toggle-radial',
            'toggle-dendrogram-labels',
            'toggle-tooltips',
            'click-to-collapse',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'fields': [{
            'model': 'dimension',
            'name': 'Dimension',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'optional': false,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Genre and Studio). Each instance of the dimension will represent a branch of its parent tree.'
        },
        {
            'model': 'facet',
            'name': 'Facet',
            'acceptableTypes': [
                'STRING',
                'DATE'
            ],
            'group': 'validate',
            'optional': true,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Nominated). The data will be grouped by each instance of the selected dimension.'
        }
        ],
        'color': {}
    },
    'tools': {
        'treeDepth': -1
    },
    'lazy': true
};
