module.exports = {
    'name': 'Change Column Type',
    'description': 'Change the column type (String, Number, Date)',
    'icon': require('images/copy.svg'),
    'widgetList': {
        'showOn': 'none'
    },
    'required': {
        'R': ['data.table'],
        'Frame': ['R', 'PY']
    },
    'content': {
        'json': [
            {
                'query': '<SMSS_FRAME.name> | ChangeColumnType(column=[<colName>],dataType=["<newType>"]);<SMSS_AUTO>',
                'label': 'Change Col Type',
                'description': 'Modify the data type of specified column (String, Number, Date).',
                'listeners': [
                    'updateTask',
                    'updateFrame',
                    'addedData',
                    'selectedData'
                ],
                'params': [
                    {
                        'paramName': 'colName',
                        'view': {
                            'displayType': 'dropdown',
                            'label': 'Select a column to modify:',
                            'attributes': {
                                'display': 'alias',
                                'value': 'alias'
                            }
                        },
                        'model': {
                            'query': '<SMSS_FRAME.name> | FrameHeaders();',
                            'autoSelect': true
                        }
                    },
                    {
                        'paramName': 'newType',
                        'view': {
                            'displayType': 'dropdown',
                            'label': 'Select the desired data type:'
                        },
                        'model': {
                            'defaultOptions': [
                                'STRING',
                                'NUMBER',
                                'DATE'
                            ],
                            'defaultValue': 'STRING'
                        }
                    }
                ],
                'execute': 'button'
            }
        ]
    },
    'pipeline': {
        'group': 'Transform'
    }
};
