module.exports = {
    'name': 'Chiclet',
    'icon': require('images/chicklet-chart.svg'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter'
        ]
    },
    'content': {
        'template': {
            'name': 'chicklet-standard'
        }
    },
    'visualization': {
        'type': [
            'standard',
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Chicklet',
        'visibleModes': [
            'default-mode',
            'comment-mode',
            'edit-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-panel',
            'color-by-value',
            'events',
            'toggle-y-axis',
            'font-settings',
            'purge',
            'reset-state',
            'refresh-cache'
        ],
        'showOnVisualPanel': true,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'Label',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': false,
            'optional': false,
            'multiField': true,
            'description': 'Select dimensions to appear in the chicklet chart.'
        },
        {
            'model': 'groupY',
            'name': 'Y-Axis Group',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': false,
            'optional': true,
            'multifield': false,
            'description': 'Group data by a category.'
        }
        ],
        'color': {}
    },
    'tools': {},
    'lazy': true
};
