module.exports = {
    'name': 'Chart Title',
    'description': 'Set the chart title',
    'icon': require('images/chart-headers.png'),
    'widgetList': {
        'showOn': 'none'
    },
    'content': {
        'json': [
            {
                'label': 'Chart Title',
                'description': 'Set a title for the chart',
                'query': 'Panel(<SMSS_PANEL_ID>)|AddPanelOrnaments({"tools":{"shared":{"chartTitle":{"text":"<title>", "fontSize":<fontSize>, "fontColor": "<fontColor>", "fontWeight": "<fontWeight>", "fontFamily": "<fontFamily>"}}}});Panel(<SMSS_PANEL_ID>)|RetrievePanelOrnaments("tools.shared.chartTitle");',
                'params': [
                    {
                        'paramName': 'title',
                        'view': {
                            'attributes': {
                                'searchable': true
                            },
                            'displayType': 'freetext',
                            'label': 'Set The Chart Title:'
                        },
                        'required': true
                    },
                    {
                        'paramName': 'fontSize',
                        'view': {
                            'displayType': 'number',
                            'label': 'Choose Text Size:'
                        },
                        'model': {
                            'defaultValue': 18,
                            'defaultOptions': []
                        },
                        'required': true
                    },
                    {
                        'paramName': 'fontColor',
                        'view': {
                            'displayType': 'color-picker',
                            'label': 'Choose a font color:'
                        },
                        'model': {
                            'defaultValue': '#000000',
                            'defaultOptions': []
                        },
                        'required': true
                    },
                    {
                        'paramName': 'fontWeight',
                        'view': {
                            'displayType': 'dropdown',
                            'label': 'Choose a font weight:'
                        },
                        'model': {
                            'defaultValue': 'normal',
                            'defaultOptions': ['normal', 'bold']
                        },
                        'required': true
                    },
                    {
                        'paramName': 'fontFamily',
                        'view': {
                            'displayType': 'freetext',
                            'label': 'Set a font style:'
                        },
                        'model': {
                            'defaultValue': 'sans-serif',
                            'defaultOptions': []
                        },
                        'required': true
                    }
                ],
                'execute': 'button'
            }
        ]
    }
};
