module.exports = {
    'name': 'Box',
    'icon': require('images/boxwhisker.png'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [
            'brush-mode'
        ],
        'quickMenu': [
            'events',
            'unfilter',
            'color-by-value'
        ]
    },
    'content': {
        'template': {
            'name': 'boxwhisker-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'BoxWhisker',
        'visibleModes': [
            'default-mode',
            'comment-mode',
            'edit-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'color-by-value',
            'display-values',
            'format-data-values',
            'flip-axis',
            'sort-values',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'X-Axis',
            'acceptableTypes': [
                'STRING'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Movie Genre). Each instance of this dimension will be shown on the x-axis.'
        },
        {
            'model': 'value',
            'name': 'Y-Axis',
            'acceptableTypes': [
                'NUMBER'
            ],
            'optional': false,
            'multiField': false,
            'description': 'Try adding one numerical dimension (i.e. Movie Budget). The values of this dimension will be shown on the y-axis.'
        }
        ]
    },
    'lazy': true
};
