module.exports = {
    'name': 'Bar Line',
    'icon': require('images/bar-chart.png'),
    'widgetList': {
        'tags': [
            'Visualization'
        ],
        'showOn': 'none',
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'flip-axis',
            'reverse-y',
            'toggle-trendline-mode',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'bar-line-echarts'
        }
    },
    'visualization': {
        'type': [
            'echarts'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Bar-Line',
        'visibleModes': [
            'default-mode',
            'comment-mode',
            'polygon-brush-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'unfilter',
            'sort-values',
            'edit-x-axis',
            'edit-y-axis',
            'edit-grid',
            'font-settings',
            'bar-image',
            'color-panel',
            'color-by-value',
            'customize-bar-label',
            'display-values',
            'flip-axis',
            'reverse-y',
            'edit-bar-width',
            'toggle-extremes',
            'toggle-average',
            'toggle-legend',
            'toggle-tooltips',
            'toggle-stack',
            'toggle-shadow',
            'toggle-trendline',
            'toggle-zoom-x',
            'toggle-zoom-y',
            'axis-pointer',
            'facet-headers',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'X-Axis',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one categorical dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.'
        },
        {
            'model': 'value',
            'name': 'Y-Axis Bars',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Budget). The numerical values of these dimensions will represent their respective column size.'
        },
        {
            'model': 'lines',
            'name': 'Y-Axis Lines',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': true,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Budget). The numerical values of these dimensions will represent their respective column size.'
        },
        {
            'model': 'tooltip',
            'name': 'Tooltip',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'math',
            'optional': true,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Movie Revenue). Each instance of this dimension will appear in the tooltip when hovering.'
        },
        {
            'model': 'facet',
            'name': 'Facet',
            'acceptableTypes': [
                'STRING',
                'DATE'
            ],
            'group': 'validate',
            'optional': true,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Nominated). The data will be grouped by each instance of the selected dimension.'
        }
        ],
        'color': {
            'value': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'lazy': true
};
