module.exports = {
    'name': 'Area',
    'icon': require('images/area-standard.svg'),
    'widgetList': {
        'tags': [
            'Visualization',
            'JVChart'
        ],
        'showOn': 'none',
        'hideHandles': [],
        'quickMenu': [
            'events',
            'unfilter',
            'color-panel-mode',
            'color-by-value',
            'infinite-viz'
        ]
    },
    'content': {
        'template': {
            'name': 'area-standard'
        }
    },
    'visualization': {
        'type': [
            'standard'
        ],
        'group': 'Visualization',
        'view': 'visualization',
        'layout': 'Area',
        'visibleModes': [
            'default-mode',
            'edit-mode',
            'comment-mode'
        ],
        'tools': [
            'custom-legend',
            'visualization-information',
            'filter',
            'color-panel',
            'color-by-value',
            'display-values',
            'format-data-values',
            'sort-values',
            'toggle-legend',
            'flip-series',
            'toggle-canvas',
            'reset-state',
            'events',
            'param',
            'purge',
            'refresh-cache'
        ],
        'showOnVisualPanel': false,
        'format': 'table',
        'fields': [{
            'model': 'label',
            'name': 'X-Axis',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'validate',
            'optional': false,
            'multiField': false,
            'description': 'Try adding one dimension (i.e. Movie Genre). Each instance within this dimension will appear on the x-axis.'
        },
        {
            'model': 'value',
            'name': 'Y-Axis',
            'acceptableTypes': [
                'NUMBER'
            ],
            'group': 'math',
            'optional': false,
            'multiField': true,
            'description': 'Try adding one or several numerical dimensions (i.e. Movie Budget). Each dimension will be represented by a colored area.'
        },
        {
            'model': 'tooltip',
            'name': 'Tooltip',
            'acceptableTypes': [
                'STRING',
                'NUMBER',
                'DATE'
            ],
            'group': 'concat',
            'optional': true,
            'multiField': true,
            'description': 'Try adding one or several dimensions (i.e. Director). Each instance of this dimension will appear in the tooltip when hovering.'
        }
        ],
        'color': {
            'value': {
                'multiField': true,
                'instances': false
            }
        }
    },
    'lazy': true
};
