module.exports = {
    'name': 'Input Description Generator',
    'description': 'Retrieve a semantic description for an input.',
    'icon': require('images/text-document.svg'),
    'widgetList': {
        'groups': [
            'analytics'
        ],
        'showOn': 'none'
    },
    'content': {
        'json': [{
            'query': "<SMSS_FRAME.name> | SemanticDescription(input=[\"<input>\"]);AddPanel(0);Panel(0)|SetPanelView(\"visualization\");Frame(SemanticMeaning) |Select(SemanticMeaning, Url).as([SemanticMeaning, Url])|With(Panel(0))|Format(type=['table'])|TaskOptions({\"0\":{\"layout\":\"Grid\",\"alignment\":{\"label\":[\"SemanticMeaning\",\"Url\"]}}})|Collect(500);Panel ( 0 ) | AddPanelOrnaments ( { \"tools\" : { \"shared\" : { \"gridStylingCols\" : [ \"Url\" ] , \"gridColStyle\" : \"Rows as links\" } } } ) ;",
            'label': 'Retrieve a semantic description for an input.',
            'description': 'Retrieve a semantic description for an input.',
            'listeners': [
                'addedData',
                'updateFrame',
                'updateTask',
                'selectedData'
            ],
            'params': [					{
                'paramName': 'input',
                'view': {
                    'displayType': 'freetext',
                    'label': 'Input Value'
                },
                'model': {
                    'replaceSpacesWithUnderscores': false
                }
            }
            ],
            'execute': 'button'
        }
        ]
    },
    'pipeline': {
        'group': 'Transform'
    }
};
