/**
 * @name smss-toggle.directive.js
 * @desc smss-toggle field
 */
export default angular.module('smss-style.toggle', [])
    .directive('smssToggle', smssToggleDirective);

import './smss-toggle.scss';


smssToggleDirective.$inject = ['$timeout'];


function smssToggleDirective($timeout) {
    smssToggleLink.$inject = ['scope', 'ele', 'attrs'];

    return {
        restrict: 'EA',
        template: require('./smss-toggle.directive.html'),
        replace: true,
        transclude: true,
        scope: {
            model: '=',
            change: '&',
            direction: '@',
            disabled: '=?ngDisabled'
        },
        link: smssToggleLink
    };

    function smssToggleLink(scope, ele, attrs) {
        scope.keydown = keydown;
        scope.keyup = keyup;
        scope.select = select;

        /**
         * @name keydown
         * @param {event} $event - angularjs event object
         * @desc when a key is pressed down
         * @returns {void}
         */
        function keydown($event) {
            if ($event.keyCode === 32) { // space
                $event.preventDefault();
            } else if ($event.keyCode === 13) { //enter
                $event.preventDefault();
            }
        }


        /**
         * @name keyup
         * @param {event} $event - angularjs event object
         * @desc when a key is pressed up
         * @returns {void}
         */
        function keyup($event) {
            if ($event.keyCode === 32) { // space
                select();
            } else if ($event.keyCode === 13) { // enter
                select();
            }
        }

        /**
         * @name select
         * @desc change the option
         * @returns {void}
         */
        function select() {
            scope.model = !scope.model;

            $timeout(function () {
                if (scope.change) {
                    scope.change({
                        model: scope.model
                    });
                }
            });
        }

        /**
         * @name initialize
         * @desc called when the directive is loaded
         * @returns {void}
         */
        function initialize() {
            if (attrs.hasOwnProperty('autofocus')) {
                $timeout(function () {
                    if (ele[0]) {
                        ele[0].focus();
                    }
                });
            }
        }

        initialize();
    }
}
