export default angular.module('smss-style.tag', [])
    .directive('smssTag', smssTagDirective);
import './smss-tag.scss';
function smssTagDirective() {
    smssTagLink.$inject = ['scope'];
    return {
        restrict: 'E',
        template: `
        <div class="smss-tag" ng-click="$event.stopPropagation();" tabindex="0"
            ng-keyup="smssTag.onKeyup($event)">
            <span class="smss-small">{{label}}</span>
            <i class="fa fa-times" ng-click="smssTag.closeTag($event);$event.stopPropagation();"></i>
        </div>
        `,
        replace: true,
        scope: {
            label: '=',
            onClose: '&'
        },
        link: smssTagLink
    };
    function smssTagLink(scope) {
        scope.smssTag = {};
        scope.smssTag.closeTag = closeTag;
        scope.smssTag.onKeyup = onKeyup;

        function closeTag(ev) {
            scope.onClose(ev);
        }
        function onKeyup(ev) {
            if (ev.keyCode === 13) { // enter
                closeTag(ev);
            }
        }
    }
}
