/* eslint-disable one-var */
const CONNECTORS = {
    'ASTER_DB': {
        'name': 'Aster',
        'driver': 'ASTER_DB',
        'type': 'RDBMS',
        'image': require('images/ASTER.png'),
        'url': 'jdbc:ncluster://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'CASSANDRA': {
        'name': 'Cassandra',
        'driver': 'CASSANDRA',
        'type': 'RDBMS',
        'image': require('images/CASSANDRA.png'),
        'url': 'jdbc:cassandra://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'DATASTAX': {
        'name': 'DataStax',
        'driver': 'DATASTAX',
        'type': 'GRAPH',
        'image': require('images/DATASTAX.png'),
        'url': ''
    },
    'DB2': {
        'name': 'DB2',
        'driver': 'DB2',
        'type': 'RDBMS',
        'image': require('images/DB2.png'),
        'url': 'jdbc:db2://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'DERBY': {
        'name': 'Derby',
        'driver': 'DERBY',
        'type': 'RDBMS',
        'image': require('images/DERBY.png'),
        'url': 'jdbc:derby://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'H2_DB': {
        'name': 'H2',
        'driver': 'H2_DB',
        'type': 'RDBMS',
        'image': require('images/H2_DB.png'),
        'url': 'jdbc:h2:tcp://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'HIVE': {
        'name': 'Hive',
        'driver': 'HIVE',
        'type': 'RDBMS',
        'image': require('images/HIVE.jpg'),
        'url': 'jdbc:hive://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'IMPALA': {
        'name': 'Impala',
        'driver': 'IMPALA',
        'type': 'RDBMS',
        'image': require('images/IMPALA.png'),
        'url': 'jdbc:impala://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'MARIA_DB': {
        'name': 'MariaDB',
        'driver': 'MARIA_DB',
        'type': 'RDBMS',
        'image': require('images/MARIA_DB.png'),
        'url': 'jdbc:mariadb://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'MYSQL': {
        'name': 'MySQL',
        'driver': 'MYSQL',
        'type': 'RDBMS',
        'image': require('images/MYSQL.png'),
        'url': 'jdbc:mysql://<HOSTNAME>:<PORT>/<SCHEMA>?user=<USERNAME>&password=<PASSWORD>'
    },
    'ORACLE': {
        'name': 'Oracle',
        'driver': 'ORACLE',
        'type': 'RDBMS',
        'image': require('images/ORACLE.png'),
        'url': 'jdbc:oracle:thin:@<HOSTNAME>:<PORT>:<SERVICE><SCHEMA>'
    },
    'PHOENIX': {
        'name': 'Phoenix',
        'driver': 'PHOENIX',
        'type': 'RDBMS',
        'image': require('images/PHOENIX.png'),
        'url': 'jdbc:phoenix://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'POSTGRES': {
        'name': 'Postgres',
        'driver': 'POSTGRES',
        'type': 'RDBMS',
        'image': require('images/POSTGRES.png'),
        'url': 'jdbc:postgresql://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'REDSHIFT': {
        'name': 'Redshift',
        'driver': 'REDSHIFT',
        'type': 'RDBMS',
        'image': require('images/REDSHIFT.png'),
        'url': 'jdbc:redshift://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'SAP_HANA': {
        'name': 'SAP Hana',
        'driver': 'SAP_HANA',
        'type': 'RDBMS',
        'image': require('images/SAP_HANA.png'),
        'url': 'jdbc:sap://<HOSTNAME>:<PORT>/?currentSchema=<SCHEMA>'
    },
    'SNOWFLAKE': {
        'name': 'Snowflake',
        'driver': 'SNOWFLAKE',
        'type': 'RDBMS',
        'image': require('images/SNOWFLAKE.png'),
        'url': 'jdbc:snowflake://<HOSTNAME>:<PORT>/?db=<SCHEMA>'
    },
    'SQL_SERVER': {
        'name': 'SQL Server',
        'driver': 'SQL_SERVER',
        'type': 'RDBMS',
        'image': require('images/SQL_SERVER.png'),
        'url': 'jdbc:sqlserver://<HOSTNAME>:<PORT>;databaseName=<SCHEMA>;user=<USERNAME>;password=<PASSWORD>;selectMethod=cursor'
    },
    'SQLITE': {
        'name': 'SQLITE',
        'driver': 'SQLITE',
        'type': 'RDBMS',
        'image': require('images/SQLITE.png'),
        'url': 'jdbc:sqlite://<HOSTNAME>:<PORT>'
    },
    'TERADATA': {
        'name': 'Teradata',
        'driver': 'TERADATA',
        'type': 'RDBMS',
        'image': require('images/TERADATA.png'),
        'url': 'jdbc:teradata://<HOSTNAME>:<PORT>/<SCHEMA>'
    },
    'TIBCO': {
        'name': 'Tibco',
        'driver': 'TIBCO',
        'type': 'RDBMS',
        'image': require('images/TIBCO.png'),
        'url': 'jdbc:compositesw:dbapi@<HOSTNAME>:<PORT>?<SCHEMA>'
    }
};

const GRAPH_TYPES = [
    'JENA',
    'SESAME',
    'TINKER',
    'NEO4J',
    'NEO4J_EMBEDDED',
    'DATASTAX_GRAPH',
    'JANUS_GRAPH',
    'RDF'
];

const FILES = {
    'csv': {
        'name': 'CSV',
        'fileType': 'csv',
        'image': require('images/CSV.svg')
    },
    'tsv': {
        'name': 'TSV',
        'fileType': 'tsv',
        'image': require('images/TSV.svg')
    },
    'excel': {
        'name': 'Excel',
        'fileType': 'excel',
        'image': require('images/EXCEL.png')
    },
    'paste': {
        'name': 'Paste',
        'fileType': 'paste',
        'image': require('images/PASTE.svg')
    }
};

const SOCIAL = {
    'dropbox': {
        'name': 'Dropbox',
        'provider': 'dropbox',
        'image': require('images/dropbox.png')
    },
    'google': {
        'name': 'Google',
        'provider': 'google',
        'image': require('images/google.png')
    },
    'ms': {
        'name': 'Microsoft',
        'provider': 'ms',
        'image': require('images/onedrive.png')
    }
};

const PREVIEW_LIMIT = 20;

const WORKSHEET = {
    sheetId: '',
    labelOverride: false,
    sheetLabel: 'Sheet 0',
    backgroundColor: 'transparent',
    hideHeaders: false,
    hideBorders: false,
    borderSize: 2,
    panel: undefined,
    history: [], // history of the selected panels
    panels: {}, // basic panel information
    golden: {} // put the golden information
};

const PANEL_TYPES = {
    GOLDEN: 'golden',
    FLOATING: 'floating',
    // old
    STANDARD: 'STANDARD',
    COLLAPSIBLE: 'COLLAPSIBLE',
    SLIDER: 'SLIDER',
    MENU: 'MENU',
    UNFILTER: 'UNFILTER'
};

const PANEL_OPTIONS = {
    GOLDEN: {
        panelId: '',
        widgetId: '',
        sheetId: '',
        labelOverride: false,
        panelLabel: '',
        config: {
            type: 'golden',
            backgroundColor: '',
            panelstatus: 'normalized',
            opacity: 100,
            componentName: 'panel'
        }

    },
    FLOATING: {
        panelId: '',
        widgetId: '',
        sheetId: '',
        labelOverride: false,
        panelLabel: '',
        config: {
            type: 'floating',
            backgroundColor: '',
            opacity: 100,
            panelstatus: 'normalized',
            top: '0%',
            left: '0%',
            height: '50%',
            width: '50%',
            zIndex: 0,
            // old
            subType: ''
        }
    }
};

export {
    CONNECTORS,
    GRAPH_TYPES,
    FILES,
    SOCIAL,
    PREVIEW_LIMIT,
    WORKSHEET,
    PANEL_TYPES,
    PANEL_OPTIONS
};
