'use strict';

/**
 * @name backupApp
 * @desc template for what user needs to run this job
 */
export default angular.module('app.backup-app.directive', [])
    .directive('backupApp', backupApp);

backupApp.$inject = ['ENDPOINT', 'semossCoreService'];

function backupApp(ENDPOINT, semossCoreService) {
    backupAppLink.$inject = ['scope'];

    return {
        restrict: 'E',
        scope: {
            job: '='
        },
        link: backupAppLink,
        template: require('./backup-app.directive.html')
    };

    function backupAppLink(scope) {
        scope.allApps = [];
        function initialize() {
            // add in props on jobTypeTemplate
            scope.job.jobTypeTemplate.app = '';

            var message = semossCoreService.utility.random('query-pixel');

            semossCoreService.once(message, function (response) {
                var output = response.pixelReturn[0].output,
                    i,
                    len;

                scope.allApps = [];

                for (i = 0, len = output.length; i < len; i++) {
                    scope.allApps.push({
                        'display': String(output[i].app_name).replace(/_/g, ' '),
                        'value': output[i].app_id,
                        'image': semossCoreService.app.generateAppImageURL(output[i].app_id)
                    });
                }

                // set a default on the dropdown as current app
                scope.job.jobTypeTemplate.app = semossCoreService.app.get('selectedApp');
            });

            semossCoreService.emit('query-pixel', {
                commandList: [{
                    meta: true,
                    type: 'getDatabaseList',
                    components: [],
                    terminal: true
                }],
                response: message
            });
        }

        scope.$watchCollection('job.jobTypeTemplate', function () {
            var query = 'BackupApp(';

            query += scope.job.jobTypeTemplate.app + ')';

            scope.job.jobTypeTemplate.templatePixelQuery = query;
        });

        initialize();
    }
}
