'use strict';

export default angular.module('app.home.home-help', [])
    .directive('homeHelp', homeHelpDirective);

import './home-help.scss';

homeHelpDirective.$inject = ['CONFIG', '$state', 'semossCoreService'];

function homeHelpDirective(CONFIG, $state, semossCoreService) {
    homeHelpCtrl.$inject = [];
    homeHelpLink.$inject = ['scope'];

    return {
        restrict: 'E',
        template: require('./home-help.directive.html'),
        scope: {},
        controller: homeHelpCtrl,
        controllerAs: 'homeHelp',
        bindToController: {
            close: '&'
        },
        link: homeHelpLink
    };

    function homeHelpCtrl() {}

    function homeHelpLink(scope) {
        scope.homeHelp.version = false;
        scope.homeHelp.action = action;

        /**
         * @name action
         * @param {string} type - type of action to perform
         * @desc peformn an action based on the help optoins
         * @returns {void}
         */
        function action(type) {
            if (type === 'introduction') {
                semossCoreService.emit('open-intro');
            } else if (type === 'tour') {
                semossCoreService.emit('start-tour', {
                    selectedState: $state.current.name,
                    selectedApp: semossCoreService.app.get('selectedApp')
                });
            } else if (type === 'userguide') {
                window.open('http://semoss.org/userguide/', '_blank');
            } else if (type === 'contact') {
                let email = window.open('mailto:semoss@semoss.org?subject=SEMOSS Help Desk', '_blank');
                setTimeout(function () {
                    email.close();
                }, 100);
            }

            scope.homeHelp.close();
        }

        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            if (CONFIG.hasOwnProperty('version')) {
                scope.homeHelp.version = {
                    version: 'V' + CONFIG.version.version,
                    date: CONFIG.version.datetime.split(' ')[0]
                };
            }
        }

        initialize();
    }
}
