import angular from 'angular';
import './app-list-dropdown.scss';

export default angular.module('app.app-list-dropdown.directive', [])
    .directive('appListDropdown', appListDropdownDirective);

appListDropdownDirective.$inject = ['$timeout','ENDPOINT', 'semossCoreService'];

function appListDropdownDirective($timeout: ng.ITimeoutService, ENDPOINT: EndPoint, semossCoreService: SemossCoreService) {
    appListDropdownCtrl.$inject = [];
    appListDropdownLink.$inject = ['scope'];

    return {
        'restrict': 'E',
        template: require('./app-list-dropdown.directive.html'),
        scope: {},
        bindToController: {
            model: '=',
            change: '&?'
        },
        controller: appListDropdownCtrl,
        controllerAs: 'appListDropdown',
        link: appListDropdownLink
    };

    function appListDropdownCtrl() { }

    function appListDropdownLink(scope) {
        scope.appListDropdown.options = [];

        scope.appListDropdown.onChange = onChange;

        /**
         * @name onChange
         * @desc called when a new option is selected
         */
        function onChange(): void {
            $timeout(() =>  {
                if (scope.appListDropdown.change) {
                    scope.appListDropdown.change({
                        list: scope.appListDropdown.options
                    });
                }
            });
        }

        function initialize(): void {
            const message = semossCoreService.utility.random('message');

            semossCoreService.once(message, (res: PixelReturnPayload) => {
                if (res.pixelReturn[0].operationType[0] === 'ERROR') {
                    semossCoreService.emit('alert', {
                        color: 'error',
                        text: 'Unable to fetch apps.'
                    });

                    return;
                }

                scope.appListDropdown.options = res.pixelReturn[0].output.map(app => ({
                    display: String(app.app_name).replace(/_/g, ' '),
                    value: app.app_id,
                    image: semossCoreService.app.generateAppImageURL(app.app_id)
                }));

                if (!scope.appListDropdown.model) {
                    scope.appListDropdown.model = scope.appListDropdown.options[0];
                    onChange();
                }
            });

            semossCoreService.emit('query-pixel', {
                commandList: [
                    {
                        type: 'getDatabaseList',
                        components: [],
                        terminal: true
                    }
                ],
                response: message
            });
        }

        initialize();
    }
}