'use strict';

import './admin-social.scss';

export default angular.module('app.admin.admin-social',
    []
).directive('adminSocial', adminSocialDirective);


adminSocialDirective.$inject = ['monolithService', 'semossCoreService'];

function adminSocialDirective(monolithService, semossCoreService) {
    adminSocialCtrl.$inject = [];
    adminSocialLink.$inject = ['scope'];

    return {
        restrict: 'E',
        template: require('./admin-social.directive.html'),
        controller: adminSocialCtrl,
        link: adminSocialLink,
        scope: {},
        bindToController: {},
        controllerAs: 'adminSocial'
    };

    function adminSocialCtrl() {}

    function adminSocialLink(scope) {
        scope.adminSocial.properties = {};

        scope.adminSocial.saveProperties = saveProperties;
        scope.adminSocial.resetProperties = resetProperties;


        /**
         * @name getProperties
         * @desc get the current properties
         * @returns {void}
         */
        function getProperties() {
            monolithService.loginProperties().then(function (response) {
                if (!response) {
                    semossCoreService.emit('alert', {
                        color: 'error',
                        text: 'Unable to fetch properties'
                    });

                    return;
                }

                // we do this to save the previous state
                let updated = {};
                for (let r in response) {
                    if (response.hasOwnProperty(r)) {
                        updated[r] = {
                            provider: r,
                            original: response[r],
                            updated: scope.adminSocial.properties[r] && scope.adminSocial.properties[r].hasOwnProperty('updated') ? scope.adminSocial.properties[r].updated : response[r],
                            open: scope.adminSocial.properties[r] && scope.adminSocial.properties[r].hasOwnProperty('open') ? scope.adminSocial.properties[r].open : false,
                            changed: false
                        };

                        updated[r].changed = JSON.stringify(updated[r].original) !== JSON.stringify(updated[r].updated);
                    }
                }

                scope.adminSocial.properties = updated;
            }, function (error) {
                semossCoreService.emit('alert', {
                    color: 'error',
                    text: error
                });
            });
        }

        /**
         * @name saveProperties
         * @desc save the edited login properties
         * @param {string} provider that was edited
         * @returns {void}
         */
        function saveProperties(provider) {
            monolithService.modifyLoginProperties(provider, scope.adminSocial.properties[provider].updated).then(function (response) {
                if (!response) {
                    semossCoreService.emit('alert', {
                        color: 'error',
                        text: 'Unable to save properties'
                    });

                    return;
                }

                // remove the old ones
                delete scope.adminSocial.properties[provider].updated;

                // refresh
                getProperties();
            }, function (error) {
                semossCoreService.emit('alert', {
                    color: 'error',
                    text: error
                });
            });
        }


        /**
         * @name resetProperties
         * @desc save the edited login properties
         * @param {string} provider that was edited
         * @returns {void}
         */
        function resetProperties(provider) {
            scope.adminSocial.properties[provider].updated = JSON.parse(JSON.stringify(scope.adminSocial.properties[provider].original));
            scope.adminSocial.properties[provider].changed = false;
        }


        /** Initialize */
        /**
         * @name initialize
         * @desc function that is called on directive load
         * @returns {void}
         */
        function initialize() {
            // cleanup
            scope.$on('$destroy', function () {
                console.log('destroying adminSocial...');
            });

            getProperties();
        }

        initialize();
    }
}
