/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.LoadableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlowLoadableComponent<T extends LoadableComponent<T>>
extends LoadableComponent<T> {
    private final Clock clock;
    private final long timeOutInSeconds;

    public SlowLoadableComponent(Clock clock, int timeOutInSeconds) {
        this.clock = clock;
        this.timeOutInSeconds = timeOutInSeconds;
    }

    @Override
    public T get() {
        try {
            this.isLoaded();
            return (T)this;
        }
        catch (Error e) {
            this.load();
            long end = this.clock.laterBy(TimeUnit.SECONDS.toMillis(this.timeOutInSeconds));
            while (this.clock.isNowBefore(end)) {
                try {
                    this.isLoaded();
                    return (T)this;
                }
                catch (Error error) {
                    this.isError();
                    this.waitFor(this.sleepFor());
                }
            }
            this.isLoaded();
            return (T)this;
        }
    }

    protected void isError() throws Error {
    }

    protected long sleepFor() {
        return 200L;
    }

    private void waitFor(long timeoutInMillis) {
        try {
            Thread.sleep(this.sleepFor());
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

