/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.testing;

import java.util.regex.Pattern;
import org.junit.Assert;

public class Assertions {
    public static void assertEquals(String expected, String actual) {
        Assert.assertTrue((String)("Expected \"" + expected + "\" but saw \"" + actual + "\" instead"), (boolean)Assertions.seleniumEquals(expected, actual));
    }

    public static void assertEquals(String expected, String[] actual) {
        Assertions.assertEquals(expected, Assertions.join(actual, ','));
    }

    private static String join(String[] sa, char c) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < sa.length; ++j) {
            sb.append(sa[j]);
            if (j >= sa.length - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean seleniumEquals(Object expected, Object actual) {
        if (expected instanceof String && actual instanceof String) {
            return Assertions.seleniumEquals((String)expected, (String)actual);
        }
        return expected.equals(actual);
    }

    private static boolean seleniumEquals(String expectedPattern, String actual) {
        Boolean b;
        if (actual.startsWith("regexp:") || actual.startsWith("regex:") || actual.startsWith("regexpi:") || actual.startsWith("regexi:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if ((b = Assertions.handleRegex("regexp:", expectedPattern, actual, 0)) != null) {
            return b;
        }
        b = Assertions.handleRegex("regex:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = Assertions.handleRegex("regexpi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        b = Assertions.handleRegex("regexi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", ".*");
        if (!Pattern.compile(expectedGlob = expectedGlob.replaceAll("\\?", "."), 32).matcher(actual).matches()) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    private static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = expectedPattern.replaceFirst(prefix, ".*") + ".*";
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    protected static String verifyEqualsAndReturnComparisonDumpIfNot(String[] expected, String[] actual) {
        boolean misMatch = false;
        if (expected.length != actual.length) {
            misMatch = true;
        }
        for (int j = 0; j < expected.length; ++j) {
            if (Assertions.seleniumEquals(expected[j], actual[j])) continue;
            misMatch = true;
            break;
        }
        if (misMatch) {
            return "Expected " + Assertions.stringArrayToString(expected) + " but saw " + Assertions.stringArrayToString(actual);
        }
        return null;
    }

    private static String stringArrayToString(String[] sa) {
        StringBuffer sb = new StringBuffer("{");
        for (int j = 0; j < sa.length; ++j) {
            sb.append(" ").append("\"").append(sa[j]).append("\"");
        }
        sb.append(" }");
        return sb.toString();
    }

    public static void assertNotEquals(Object expected, Object actual) {
        if (expected.equals(actual)) {
            Assert.fail((String)("did not expect values to be equal (" + expected.toString() + ")"));
        }
    }
}

