/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.jdbc;

import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeRestartedEvent;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.jdbc.JdbcException;
import org.openqa.selenium.grid.sessionmap.jdbc.JdbcSessionMapOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class JdbcBackedSessionMap
extends SessionMap
implements Closeable {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(JdbcBackedSessionMap.class.getName());
    private static final String TABLE_NAME = "sessions_map";
    private static final String SESSION_ID_COL = "session_ids";
    private static final String SESSION_CAPS_COL = "session_caps";
    private static final String SESSION_STEREOTYPE_COL = "session_stereotype";
    private static final String SESSION_URI_COL = "session_uri";
    private static final String SESSION_START_COL = "session_start";
    private static final String DATABASE_STATEMENT = AttributeKey.DATABASE_STATEMENT.getKey();
    private static final String DATABASE_OPERATION = AttributeKey.DATABASE_OPERATION.getKey();
    private static final String DATABASE_USER = AttributeKey.DATABASE_USER.getKey();
    private static final String DATABASE_CONNECTION_STRING = AttributeKey.DATABASE_CONNECTION_STRING.getKey();
    private static String jdbcUser;
    private static String jdbcUrl;
    private final EventBus bus;
    private final Connection connection;

    public JdbcBackedSessionMap(Tracer tracer, Connection jdbcConnection, EventBus bus) {
        super(tracer);
        Require.nonNull((String)"JDBC Connection Object", (Object)jdbcConnection);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.connection = jdbcConnection;
        this.bus.addListener(SessionClosedEvent.listener(this::remove));
        this.bus.addListener(NodeRemovedEvent.listener(nodeStatus -> nodeStatus.getSlots().stream().filter(slot -> slot.getSession() != null).map(slot -> slot.getSession().getId()).forEach(this::remove)));
        bus.addListener(NodeRestartedEvent.listener(nodeStatus -> this.removeByUri(nodeStatus.getExternalUri())));
    }

    public static SessionMap create(Config config) {
        Connection connection;
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        JdbcSessionMapOptions sessionMapOptions = new JdbcSessionMapOptions(config);
        try {
            jdbcUser = sessionMapOptions.getJdbcUser();
            jdbcUrl = sessionMapOptions.getJdbcUrl();
            connection = sessionMapOptions.getJdbcConnection();
        }
        catch (SQLException e) {
            throw new ConfigException((Throwable)e);
        }
        return new JdbcBackedSessionMap(tracer, connection, bus);
    }

    public boolean isReady() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException throwable) {
            return false;
        }
    }

    public boolean add(Session session) {
        Require.nonNull((String)"Session to add", (Object)session);
        try (Span span = this.tracer.getCurrentContext().createSpan("INSERT into  sessions_map (session_ids, session_uri, session_caps, session_start) values (?, ?, ?, ?) ");){
            boolean bl;
            block15: {
                HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
                RemoteTags.SESSION_ID.accept(span, session.getId());
                RemoteTags.SESSION_ID_EVENT.accept(attributeMap, session.getId());
                RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
                RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, session.getCapabilities());
                this.setCommonSpanAttributes(span);
                this.setCommonEventAttributes(attributeMap);
                attributeMap.put(AttributeKey.SESSION_URI.getKey(), EventAttribute.setValue((String)session.getUri().toString()));
                PreparedStatement statement = this.connection.prepareStatement(String.format("insert into %1$s (%2$s, %3$s, %4$s, %5$s, %6$s) values (?, ?, ?, ?, ?)", TABLE_NAME, SESSION_ID_COL, SESSION_URI_COL, SESSION_STEREOTYPE_COL, SESSION_CAPS_COL, SESSION_START_COL));
                try {
                    statement.setString(1, session.getId().toString());
                    statement.setString(2, session.getUri().toString());
                    statement.setString(3, JSON.toJson((Object)session.getStereotype()));
                    statement.setString(4, JSON.toJson((Object)session.getCapabilities()));
                    statement.setString(5, JSON.toJson((Object)session.getStartTime()));
                    String statementStr = statement.toString();
                    span.setAttribute(DATABASE_STATEMENT, statementStr);
                    span.setAttribute(DATABASE_OPERATION, "insert");
                    attributeMap.put(DATABASE_STATEMENT, EventAttribute.setValue((String)statementStr));
                    attributeMap.put(DATABASE_OPERATION, EventAttribute.setValue((String)"insert"));
                    int rowCount = statement.executeUpdate();
                    attributeMap.put("rows.added", EventAttribute.setValue((long)rowCount));
                    span.addEvent("Inserted into the database", attributeMap);
                    boolean bl2 = bl = rowCount >= 1;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        span.setAttribute("error", true);
                        span.setStatus(Status.CANCELLED);
                        Tags.EXCEPTION.accept(attributeMap, e);
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to add session information to the database: " + e.getMessage())));
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        throw new JdbcException(e);
                    }
                }
                statement.close();
            }
            return bl;
        }
    }

    public Session get(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        URI uri = null;
        ImmutableCapabilities stereotype = null;
        ImmutableCapabilities caps = null;
        Instant start = null;
        String rawUri = null;
        HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
        try (Span span = this.tracer.getCurrentContext().createSpan("SELECT * from  sessions_map where session_ids = ?");){
            Session session;
            block25: {
                RemoteTags.SESSION_ID.accept(span, id);
                RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
                this.setCommonSpanAttributes(span);
                this.setCommonEventAttributes(attributeMap);
                PreparedStatement statement = this.connection.prepareStatement(String.format("select * from %1$s where %2$s = ?", TABLE_NAME, SESSION_ID_COL));
                try {
                    statement.setMaxRows(1);
                    statement.setString(1, id.toString());
                    String statementStr = statement.toString();
                    span.setAttribute(DATABASE_STATEMENT, statementStr);
                    span.setAttribute(DATABASE_OPERATION, "select");
                    attributeMap.put(DATABASE_OPERATION, EventAttribute.setValue((String)"select"));
                    attributeMap.put(DATABASE_STATEMENT, EventAttribute.setValue((String)statementStr));
                    try (ResultSet sessions = statement.executeQuery();){
                        if (!sessions.next()) {
                            NoSuchSessionException exception = new NoSuchSessionException("Unable to find session.");
                            span.setAttribute("error", true);
                            span.setStatus(Status.NOT_FOUND);
                            Tags.EXCEPTION.accept(attributeMap, exception);
                            attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Session id does not exist in the database :" + exception.getMessage())));
                            span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                            throw exception;
                        }
                        rawUri = sessions.getString(SESSION_URI_COL);
                        String rawStereotype = sessions.getString(SESSION_STEREOTYPE_COL);
                        stereotype = rawStereotype == null ? new ImmutableCapabilities() : (Capabilities)JSON.toType(rawStereotype, Capabilities.class);
                        String rawCapabilities = sessions.getString(SESSION_CAPS_COL);
                        caps = rawCapabilities == null ? new ImmutableCapabilities() : (Capabilities)JSON.toType(rawCapabilities, Capabilities.class);
                        String rawStart = sessions.getString(SESSION_START_COL);
                        start = (Instant)JSON.toType(rawStart, Instant.class);
                    }
                    RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, caps);
                    try {
                        attributeMap.put(AttributeKey.SESSION_URI.getKey(), EventAttribute.setValue((String)rawUri));
                        uri = new URI(rawUri);
                    }
                    catch (URISyntaxException e) {
                        span.setAttribute("error", true);
                        span.setStatus(Status.INTERNAL);
                        Tags.EXCEPTION.accept(attributeMap, e);
                        attributeMap.put(AttributeKey.SESSION_URI.getKey(), EventAttribute.setValue((String)rawUri));
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to convert session id to uri: " + e.getMessage())));
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        throw new NoSuchSessionException(String.format("Unable to convert session id (%s) to uri: %s", id, rawUri), (Throwable)e);
                    }
                    span.addEvent("Retrieved session from the database", attributeMap);
                    session = new Session(id, uri, (Capabilities)stereotype, (Capabilities)caps, start);
                    if (statement == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        span.setAttribute("error", true);
                        span.setStatus(Status.CANCELLED);
                        Tags.EXCEPTION.accept(attributeMap, e);
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to get session information from the database: " + e.getMessage())));
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        throw new JdbcException(e);
                    }
                }
                statement.close();
            }
            return session;
        }
    }

    public void remove(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        try (Span span = this.tracer.getCurrentContext().createSpan("DELETE from  sessions_map where session_ids = ?");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            this.setCommonSpanAttributes(span);
            this.setCommonEventAttributes(attributeMap);
            try (PreparedStatement statement = this.connection.prepareStatement(String.format("delete from %1$s where %2$s = ?", TABLE_NAME, SESSION_ID_COL));){
                statement.setString(1, id.toString());
                String statementStr = statement.toString();
                span.setAttribute(DATABASE_STATEMENT, statementStr);
                span.setAttribute(DATABASE_OPERATION, "delete");
                attributeMap.put(DATABASE_STATEMENT, EventAttribute.setValue((String)statementStr));
                attributeMap.put(DATABASE_OPERATION, EventAttribute.setValue((String)"delete"));
                int rowCount = statement.executeUpdate();
                attributeMap.put("rows.deleted", EventAttribute.setValue((long)rowCount));
                span.addEvent("Deleted session from the database", attributeMap);
            }
            catch (SQLException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to delete session information from the database: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                throw new JdbcException(e.getMessage());
            }
        }
    }

    public void removeByUri(URI sessionUri) {
        Require.nonNull((String)"Session URI", (Object)sessionUri);
        try (Span span = this.tracer.getCurrentContext().createSpan("DELETE from  sessions_map where session_uri = ?");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            try (PreparedStatement statement = this.connection.prepareStatement(String.format("delete from %1$s where %2$s = ?", TABLE_NAME, SESSION_URI_COL));){
                statement.setString(1, sessionUri.toString());
                String statementStr = statement.toString();
                span.setAttribute(DATABASE_STATEMENT, statementStr);
                span.setAttribute(DATABASE_OPERATION, "delete");
                attributeMap.put(DATABASE_STATEMENT, EventAttribute.setValue((String)statementStr));
                attributeMap.put(DATABASE_OPERATION, EventAttribute.setValue((String)"delete"));
                int rowCount = statement.executeUpdate();
                attributeMap.put("rows.deleted", EventAttribute.setValue((long)rowCount));
                span.addEvent("Deleted session from the database", attributeMap);
            }
            catch (SQLException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to delete session information from the database: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                throw new JdbcException(e.getMessage());
            }
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.warning("SQL exception while closing JDBC Connection:" + e.getMessage());
        }
    }

    private void setCommonSpanAttributes(Span span) {
        span.setAttribute("span.kind", Span.Kind.CLIENT.toString());
        if (jdbcUser != null) {
            span.setAttribute(DATABASE_USER, jdbcUser);
        }
        if (jdbcUrl != null) {
            span.setAttribute(DATABASE_CONNECTION_STRING, jdbcUrl);
        }
    }

    private void setCommonEventAttributes(Map<String, EventAttributeValue> attributeMap) {
        if (jdbcUser != null) {
            attributeMap.put(DATABASE_USER, EventAttribute.setValue((String)jdbcUser));
        }
        if (jdbcUrl != null) {
            attributeMap.put(DATABASE_CONNECTION_STRING, EventAttribute.setValue((String)jdbcUrl));
        }
    }
}

