/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.config.ConfigValue;

public class AnnotatedConfig
implements Config {
    private final Map<String, Map<String, List<String>>> config;

    public AnnotatedConfig(Object obj) {
        HashMap<String, Map<String, List<String>>> values = new HashMap<String, Map<String, List<String>>>();
        Deque<Field> allConfigValues = this.findConfigFields(obj.getClass());
        for (Field field : allConfigValues) {
            Object value;
            if (Map.class.isAssignableFrom(field.getType())) {
                throw new ConfigException("Map fields may not be used for configuration: " + field, new Object[0]);
            }
            field.setAccessible(true);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new ConfigException("Unable to read field: " + field, new Object[0]);
            }
            ConfigValue annotation = field.getAnnotation(ConfigValue.class);
            Map section = values.computeIfAbsent(annotation.section(), str -> new HashMap());
            List all = section.computeIfAbsent(annotation.name(), str -> new LinkedList());
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    String singleValue = this.getSingleValue(o);
                    if (singleValue == null) continue;
                    all.add(singleValue);
                }
                continue;
            }
            String singleValue = this.getSingleValue(value);
            if (singleValue == null) continue;
            all.add(singleValue);
        }
        this.config = values;
    }

    private String getSingleValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            throw new ConfigException("Map fields may not be used for configuration: " + value, new Object[0]);
        }
        if (value instanceof Collection) {
            throw new ConfigException("Collection fields may not be used for configuration: " + value, new Object[0]);
        }
        if (Boolean.FALSE.equals(value)) {
            return null;
        }
        if (value instanceof Number && ((Number)value).floatValue() == 0.0f) {
            return null;
        }
        return String.valueOf(value);
    }

    private Deque<Field> findConfigFields(Class<?> clazz) {
        ArrayDeque<Field> toSet = new ArrayDeque<Field>();
        HashSet toVisit = new HashSet();
        toVisit.add(clazz);
        HashSet<Class> seen = new HashSet<Class>();
        while (!toVisit.isEmpty()) {
            clazz = (Class)toVisit.iterator().next();
            toVisit.remove(clazz);
            seen.add(clazz);
            Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotation(ConfigValue.class) != null).forEach(toSet::addLast);
            Class toAdd = clazz.getSuperclass();
            if (!Object.class.equals(toAdd) && !seen.contains(toAdd)) {
                toVisit.add(toAdd);
            }
            Arrays.stream(clazz.getInterfaces()).filter(face -> !seen.contains(face)).forEach(toVisit::add);
        }
        return toSet;
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Objects.requireNonNull(section, "Section name not set");
        Objects.requireNonNull(option, "Option name not set");
        Map<String, List<String>> sec = this.config.get(section);
        if (sec == null || sec.isEmpty()) {
            return Optional.empty();
        }
        List<String> values = sec.get(option);
        if (values == null || values.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf(values));
    }
}

