/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import org.openqa.selenium.events.Type;
import org.openqa.selenium.json.Json;

public class Event {
    private static final Json JSON = new Json();
    private final UUID id;
    private final Type type;
    private final String data;

    public Event(Type type, Object data) {
        this(UUID.randomUUID(), type, data);
    }

    public Event(UUID id, Type type, Object data) {
        this.id = Objects.requireNonNull(id, "Message id must be set.");
        this.type = Objects.requireNonNull(type, "Event type must be set.");
        this.data = JSON.toJson(data);
    }

    public UUID getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public <T> T getData(java.lang.reflect.Type typeOfT) {
        return (T)JSON.toType(this.data, typeOfT);
    }

    public String getRawData() {
        return this.data;
    }

    public String toString() {
        return new StringJoiner(", ", Event.class.getSimpleName() + "[", "]").add("id=" + this.id).add("type=" + this.type).add("data=" + this.data).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Event)) {
            return false;
        }
        Event that = (Event)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getRawData(), that.getRawData());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getType(), this.data);
    }
}

