/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration.json;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openqa.grid.common.GridConfiguredJson;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public abstract class CommonJsonConfiguration {
    private String role;
    private Boolean debug = false;
    private String log;
    private String host;
    private Integer port;
    private Integer timeout;
    private Integer browserTimeout;
    private Integer jettyMaxThreads;

    static <T extends CommonJsonConfiguration> T fromResourceOrFile(String resourceOrFilePath, Class<T> configurationClass) {
        return CommonJsonConfiguration.fromJson(CommonJsonConfiguration.loadJsonFromResourceOrFile(resourceOrFilePath), configurationClass);
    }

    static <T extends CommonJsonConfiguration> T fromJson(JsonInput jsonInput, Class<T> configurationClass) {
        try {
            return (T)((CommonJsonConfiguration)GridConfiguredJson.toType(jsonInput, configurationClass));
        }
        catch (GridConfigurationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GridConfigurationException(e.getMessage(), e);
        }
    }

    private static JsonInput loadJsonFromResourceOrFile(String source) {
        try {
            return new Json().newInput(CommonJsonConfiguration.readFileOrResource(source));
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException("Unable to load configuration from " + source, e);
        }
    }

    private static Reader readFileOrResource(String source) {
        Stream<Function> suppliers = Stream.of(path -> {
            try {
                return new FileInputStream((String)path);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }, path -> Thread.currentThread().getContextClassLoader().getResourceAsStream("org/openqa/grid/common/" + path), path -> Thread.currentThread().getContextClassLoader().getResourceAsStream((String)path), path -> new ByteArrayInputStream(path.getBytes()));
        InputStream in = suppliers.map(supplier -> (InputStream)supplier.apply(source)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException("Resource or file not found: " + source));
        return new BufferedReader(new InputStreamReader(in));
    }

    public CommonJsonConfiguration() {
    }

    public CommonJsonConfiguration(CommonJsonConfiguration commonJsonConfig) {
        this.role = commonJsonConfig.role;
        this.debug = commonJsonConfig.debug;
        this.log = commonJsonConfig.log;
        this.host = commonJsonConfig.host;
        this.port = commonJsonConfig.port;
        this.timeout = commonJsonConfig.timeout;
        this.browserTimeout = commonJsonConfig.browserTimeout;
        this.jettyMaxThreads = commonJsonConfig.jettyMaxThreads;
    }

    protected String getRole() {
        return this.role;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public String getLog() {
        return this.log;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getBrowserTimeout() {
        return this.browserTimeout;
    }

    public Integer getJettyMaxThreads() {
        return this.jettyMaxThreads;
    }
}

