/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.CommandHandler;

public class NoSessionHandler
implements CommandHandler {
    private final Json json;
    private final SessionId sessionId;

    public NoSessionHandler(Json json, SessionId sessionId) {
        this.json = Objects.requireNonNull(json);
        this.sessionId = Objects.requireNonNull(sessionId);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Map<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("sessionId", this.sessionId.toString());
        responseMap.put("status", 6);
        responseMap.put("value", ImmutableMap.of((Object)"error", (Object)"invalid session id", (Object)"message", (Object)String.format("No active session with ID %s", this.sessionId), (Object)"stacktrace", (Object)""));
        responseMap = Collections.unmodifiableMap(responseMap);
        byte[] payload = this.json.toJson(responseMap).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(404);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

