/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.safari.SafariOptions;

public class DefaultCapabilityMatcher
implements CapabilityMatcher {
    private static final String GRID_TOKEN = "_";
    private final List<Validator> validators = ImmutableList.of((Object)new PlatformValidator(), (Object)new AliasedPropertyValidator("browserName", "browser"), (Object)new AliasedPropertyValidator("browserVersion", "version"), (Object)new SimplePropertyValidator("applicationName"), (Object)new FirefoxSpecificValidator(), (Object)new SafariSpecificValidator());

    private boolean anything(Object requested) {
        return requested == null || ImmutableList.of((Object)"any", (Object)"", (Object)"*").contains((Object)requested.toString().toLowerCase());
    }

    @Override
    public boolean matches(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
        return providedCapabilities != null && requestedCapabilities != null && this.validators.stream().allMatch(v -> (Boolean)v.apply(providedCapabilities, requestedCapabilities));
    }

    private Platform extractPlatform(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Platform) {
            return (Platform)o;
        }
        try {
            return Platform.fromString((String)o.toString());
        }
        catch (WebDriverException ex) {
            return null;
        }
    }

    class SafariSpecificValidator
    implements Validator {
        SafariSpecificValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            if (!"safari".equals(requestedCapabilities.get("browserName"))) {
                return true;
            }
            SafariOptions requestedOptions = new SafariOptions((Capabilities)new ImmutableCapabilities(requestedCapabilities));
            if (requestedOptions.getUseTechnologyPreview()) {
                return providedCapabilities.get("technologyPreview") != null && Boolean.valueOf(providedCapabilities.get("technologyPreview").toString()) != false;
            }
            return providedCapabilities.get("technologyPreview") == null || Boolean.valueOf(providedCapabilities.get("technologyPreview").toString()) == false;
        }
    }

    class FirefoxSpecificValidator
    implements Validator {
        FirefoxSpecificValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            if (!"firefox".equals(requestedCapabilities.get("browserName"))) {
                return true;
            }
            FirefoxOptions requestedOptions = new FirefoxOptions((Capabilities)new ImmutableCapabilities(requestedCapabilities));
            if (requestedOptions.isLegacy()) {
                return providedCapabilities.get("marionette") != null && Boolean.valueOf(providedCapabilities.get("marionette").toString()) == false;
            }
            return providedCapabilities.get("marionette") == null || Boolean.valueOf(providedCapabilities.get("marionette").toString()) != false;
        }
    }

    class SimplePropertyValidator
    implements Validator {
        private List<String> toConsider;

        SimplePropertyValidator(String ... toConsider) {
            this.toConsider = Arrays.asList(toConsider);
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            return requestedCapabilities.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(DefaultCapabilityMatcher.GRID_TOKEN)).filter(entry -> this.toConsider.contains(entry.getKey())).filter(entry -> !DefaultCapabilityMatcher.this.anything(entry.getValue())).allMatch(entry -> entry.getValue().equals(providedCapabilities.get(entry.getKey())));
        }
    }

    class AliasedPropertyValidator
    implements Validator {
        private String[] propertyAliases;

        AliasedPropertyValidator(String ... propertyAliases) {
            this.propertyAliases = propertyAliases;
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            Object requested = Stream.of(this.propertyAliases).map(requestedCapabilities::get).filter(Objects::nonNull).findFirst().orElse(null);
            if (DefaultCapabilityMatcher.this.anything(requested)) {
                return true;
            }
            Object provided = Stream.of(this.propertyAliases).map(providedCapabilities::get).filter(Objects::nonNull).findFirst().orElse(null);
            return Objects.equals(requested, provided);
        }
    }

    class PlatformValidator
    implements Validator {
        PlatformValidator() {
        }

        @Override
        public Boolean apply(Map<String, Object> providedCapabilities, Map<String, Object> requestedCapabilities) {
            Object requested = requestedCapabilities.get("platform");
            if (DefaultCapabilityMatcher.this.anything(requested)) {
                return true;
            }
            Object provided = providedCapabilities.get("platform");
            Platform requestedPlatform = DefaultCapabilityMatcher.this.extractPlatform(requested);
            if (requestedPlatform != null) {
                Platform providedPlatform = DefaultCapabilityMatcher.this.extractPlatform(provided);
                return providedPlatform != null && providedPlatform.is(requestedPlatform);
            }
            return provided != null && Objects.equals(requested.toString(), provided.toString());
        }
    }

    static interface Validator
    extends BiFunction<Map<String, Object>, Map<String, Object>, Boolean> {
    }
}

