/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.CommandHandler;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class BeginSession
implements CommandHandler {
    private final Logger LOG = Logger.getLogger(BeginSession.class.getName());
    private final NewSessionPipeline pipeline;
    private final ActiveSessions allSessions;
    private final Json json;

    public BeginSession(NewSessionPipeline pipeline, ActiveSessions allSessions, Json json) {
        this.pipeline = pipeline;
        this.allSessions = allSessions;
        this.json = json;
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        ImmutableMap toConvert;
        ActiveSession session;
        String lengthString = req.getHeader("Content-Length");
        long contentLength = Long.MAX_VALUE;
        if (lengthString != null) {
            try {
                contentLength = Long.parseLong(lengthString);
            }
            catch (NumberFormatException e) {
                contentLength = Long.MAX_VALUE;
            }
        }
        try (InputStreamReader reader = new InputStreamReader(req.consumeContentStream(), req.getContentEncoding());
             NewSessionPayload payload = NewSessionPayload.create((Reader)reader);){
            session = this.pipeline.createNewSession(payload);
            this.allSessions.put(session);
        }
        LoggingPreferences loggingPrefs = new LoggingPreferences();
        loggingPrefs.enable("server", Level.INFO);
        Object raw = session.getCapabilities().get("loggingPrefs");
        if (raw instanceof LoggingPreferences) {
            loggingPrefs.addPreferences((LoggingPreferences)raw);
        }
        LoggingManager.perSessionLogHandler().configureLogging(loggingPrefs);
        LoggingManager.perSessionLogHandler().attachToCurrentThread(session.getId());
        switch (session.getDownstreamDialect()) {
            case OSS: {
                toConvert = ImmutableMap.of((Object)"status", (Object)0, (Object)"sessionId", (Object)session.getId().toString(), (Object)"value", session.getCapabilities());
                break;
            }
            case W3C: {
                toConvert = ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"sessionId", (Object)session.getId().toString(), (Object)"capabilities", session.getCapabilities()));
                break;
            }
            default: {
                throw new SessionNotCreatedException("Unrecognized downstream dialect: " + session.getDownstreamDialect());
            }
        }
        byte[] payload = this.json.toJson((Object)toConvert).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

