/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.ActiveSessionListener;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;

public class ActiveSessions {
    private static final Logger LOG = Logger.getLogger(ActiveSessions.class.getName());
    private final Cache<SessionId, ActiveSession> allSessions;
    private final List<ActiveSessionListener> listeners = new LinkedList<ActiveSessionListener>();

    public ActiveSessions(long inactiveSessionTimeout, TimeUnit unit) {
        RemovalListener listener = notification -> {
            ActiveSession session = (ActiveSession)notification.getValue();
            this.listeners.forEach(l -> l.onStop(session));
            session.stop();
        };
        this.allSessions = CacheBuilder.newBuilder().expireAfterAccess(inactiveSessionTimeout, unit).removalListener(listener).build();
        this.addListener(new ActiveSessionListener(){

            @Override
            public void onStop(ActiveSession session) {
                ActiveSessions.this.log("Removing session %s", new Object[]{session});
            }
        });
        this.addListener(new ActiveSessionListener(){

            @Override
            public void onStop(ActiveSession session) {
                PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
                logHandler.transferThreadTempLogsToSessionLogs(session.getId());
                logHandler.removeSessionLogs(session.getId());
            }
        });
    }

    public void put(ActiveSession session) {
        this.allSessions.put((Object)session.getId(), (Object)session);
    }

    public ActiveSession get(SessionId id) {
        ActiveSession session = (ActiveSession)this.allSessions.getIfPresent((Object)id);
        if (session != null) {
            this.listeners.forEach(l -> l.onAccess(session));
        }
        return session;
    }

    public void invalidate(SessionId id) {
        this.allSessions.invalidate((Object)id);
    }

    public void addListener(ActiveSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ActiveSessionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return this.allSessions.asMap().toString();
    }

    private void log(String message, Object ... args) {
        LOG.info(String.format(message, args));
    }

    private void log(Throwable throwable, String message, Object ... args) {
        LOG.log(Level.WARNING, String.format(message, args), throwable);
    }
}

