/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import java.util.Map;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.selenium.json.JsonInput;

public class GridHubConfiguration
extends GridConfiguration {
    public static final String DEFAULT_HUB_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultHub.json";
    static final String DEFAULT_ROLE = "hub";
    static final Integer DEFAULT_PORT = 4444;
    static final Integer DEFAULT_CLEANUP_CYCLE = 5000;
    static final Integer DEFAULT_NEW_SESSION_WAIT_TIMEOUT = -1;
    static final Boolean DEFAULT_THROW_ON_CAPABILITY_NOT_PRESENT_TOGGLE = true;
    static final String DEFAULT_HUB_REGISTRY_CLASS = "org.openqa.grid.internal.DefaultGridRegistry";
    public String hubConfig;
    public CapabilityMatcher capabilityMatcher = new DefaultCapabilityMatcher();
    public Integer newSessionWaitTimeout = DEFAULT_NEW_SESSION_WAIT_TIMEOUT;
    public Prioritizer prioritizer;
    public Boolean throwOnCapabilityNotPresent = DEFAULT_THROW_ON_CAPABILITY_NOT_PRESENT_TOGGLE;
    public String registry = "org.openqa.grid.internal.DefaultGridRegistry";

    public GridHubConfiguration() {
        this.role = DEFAULT_ROLE;
        this.port = DEFAULT_PORT;
        this.cleanUpCycle = DEFAULT_CLEANUP_CYCLE;
    }

    public static GridHubConfiguration loadFromJSON(String filePath) {
        return GridHubConfiguration.loadFromJSON(StandaloneConfiguration.loadJsonFromResourceOrFile(filePath));
    }

    public static GridHubConfiguration loadFromJSON(JsonInput jsonInput) {
        try {
            GridHubConfiguration config = StandaloneConfiguration.loadFromJson(jsonInput, GridHubConfiguration.class);
            GridHubConfiguration result = new GridHubConfiguration();
            result.merge(config);
            if (config.host != null) {
                result.host = config.host;
            }
            if (config.port != null) {
                result.port = config.port;
            }
            return result;
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void merge(GridNodeConfiguration other) {
        super.merge(other);
    }

    public void merge(GridHubConfiguration other) {
        if (other == null) {
            return;
        }
        super.merge(other);
        if (this.isMergeAble(CapabilityMatcher.class, other.capabilityMatcher, this.capabilityMatcher)) {
            this.capabilityMatcher = other.capabilityMatcher;
        }
        if (this.isMergeAble(Integer.class, other.newSessionWaitTimeout, this.newSessionWaitTimeout)) {
            this.newSessionWaitTimeout = other.newSessionWaitTimeout;
        }
        if (this.isMergeAble(Prioritizer.class, other.prioritizer, this.prioritizer)) {
            this.prioritizer = other.prioritizer;
        }
        if (this.isMergeAble(Boolean.class, other.throwOnCapabilityNotPresent, this.throwOnCapabilityNotPresent)) {
            this.throwOnCapabilityNotPresent = other.throwOnCapabilityNotPresent;
        }
        if (this.isMergeAble(String.class, other.registry, this.registry)) {
            this.registry = other.registry;
        }
    }

    @Override
    protected void serializeFields(Map<String, Object> appendTo) {
        super.serializeFields(appendTo);
        appendTo.put("capabilityMatcher", this.capabilityMatcher.getClass().getName());
        appendTo.put("newSessionWaitTimeout", this.newSessionWaitTimeout);
        appendTo.put("prioritizer", this.prioritizer == null ? null : this.prioritizer.getClass().getName());
        appendTo.put("throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent);
        appendTo.put("registry", this.registry);
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "hubConfig", this.hubConfig));
        sb.append((CharSequence)this.toString(format, "capabilityMatcher", this.capabilityMatcher.getClass().getCanonicalName()));
        sb.append((CharSequence)this.toString(format, "newSessionWaitTimeout", this.newSessionWaitTimeout));
        sb.append((CharSequence)this.toString(format, "prioritizer", this.prioritizer != null ? this.prioritizer.getClass().getCanonicalName() : null));
        sb.append((CharSequence)this.toString(format, "throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent));
        sb.append((CharSequence)this.toString(format, "registry", this.registry));
        return sb.toString();
    }
}

