/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.Map;
import org.openqa.grid.internal.cli.CommonGridCliOptions;
import org.openqa.grid.internal.cli.FileExistsValueValidator;
import org.openqa.grid.internal.cli.StringToClassConverter;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.selenium.json.Json;

public class GridHubCliOptions
extends CommonGridCliOptions {
    @Parameter(names={"-hubConfig"}, description="<String> filename: a JSON file (following grid2 format), which defines the hub properties", validateValueWith={FileExistsValueValidator.class})
    private String configFile;
    @Parameter(names={"-matcher", "-capabilityMatcher"}, description="<String> class name : a class implementing the CapabilityMatcher interface. Specifies the logic the hub will follow to define whether a request can be assigned to a node. For example, if you want to have the matching process use regular expressions instead of exact match when specifying browser version. ALL nodes of a grid ecosystem would then use the same capabilityMatcher, as defined here.", converter=StringToClassConverter.CapabilityMatcherStringConverter.class)
    private CapabilityMatcher capabilityMatcher;
    @Parameter(names={"-newSessionWaitTimeout"}, description="<Integer> in ms : The time after which a new test waiting for a node to become available will time out. When that happens, the test will throw an exception before attempting to start a browser. An unspecified, zero, or negative value means wait indefinitely.")
    private Integer newSessionWaitTimeout;
    @Parameter(names={"-prioritizer"}, description="<String> class name : a class implementing the Prioritizer interface. Specify a custom Prioritizer if you want to sort the order in which new session requests are processed when there is a queue. Default to null ( no priority = FIFO )", converter=StringToClassConverter.PrioritizerStringConverter.class)
    private Prioritizer prioritizer;
    @Parameter(names={"-throwOnCapabilityNotPresent"}, description="<Boolean> true or false : If true, the hub will reject all test requests if no compatible proxy is currently registered. If set to false, the request will queue until a node supporting the capability is registered with the grid.", arity=1)
    private Boolean throwOnCapabilityNotPresent;
    @Parameter(names={"-registry"}, description="<String> class name : a class implementing the GridRegistry interface. Specifies the registry the hub will use.")
    private String registry;

    public GridHubCliOptions parse(String[] args) {
        JCommander.newBuilder().addObject((Object)this).build().parse(args);
        if (this.configFile != null) {
            JCommander.newBuilder().addObject((Object)this).defaultProvider(this.defaults(this.fromConfigFile(this.configFile))).build().parse(args);
        }
        return this;
    }

    private IDefaultProvider defaults(String json) {
        Map map = (Map)new Json().toType(json, Map.class);
        map.remove("custom");
        return optionName -> {
            String option = optionName.replaceAll("-", "");
            return map.containsKey(option) && map.get(option) != null ? map.get(option).toString() : null;
        };
    }

    @Override
    public GridHubConfiguration toConfiguration() {
        GridHubConfiguration configuration = GridHubConfiguration.loadFromJSON(this.configFile == null ? "org/openqa/grid/common/defaults/DefaultHub.json" : this.configFile);
        this.fillCommonConfiguration(configuration);
        this.fillCommonGridConfiguration(configuration);
        if (this.configFile != null) {
            configuration.hubConfig = this.configFile;
        }
        if (this.capabilityMatcher != null) {
            configuration.capabilityMatcher = this.capabilityMatcher;
        }
        if (this.newSessionWaitTimeout != null) {
            configuration.newSessionWaitTimeout = this.newSessionWaitTimeout;
        }
        if (this.prioritizer != null) {
            configuration.prioritizer = this.prioritizer;
        }
        if (this.throwOnCapabilityNotPresent != null) {
            configuration.throwOnCapabilityNotPresent = this.throwOnCapabilityNotPresent;
        }
        if (this.registry != null) {
            configuration.registry = this.registry;
        }
        return configuration;
    }
}

