/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.ClientGoneException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.NewSessionPayload;

public class RequestHandler
implements Comparable<RequestHandler> {
    private static final Logger log = Logger.getLogger(RequestHandler.class.getName());
    private final GridRegistry registry;
    private final SeleniumBasedRequest request;
    private final HttpServletResponse response;
    private final CountDownLatch sessionAssigned = new CountDownLatch(1);
    private final Thread waitingThread;
    private volatile TestSession session = null;

    public RequestHandler(SeleniumBasedRequest request, HttpServletResponse response, GridRegistry registry) {
        this.request = request;
        this.response = response;
        this.registry = registry;
        this.waitingThread = Thread.currentThread();
    }

    public void forwardNewSessionRequestAndUpdateRegistry(TestSession session) throws NewSessionException {
        try (NewSessionPayload payload = NewSessionPayload.create((Map)ImmutableMap.of((Object)"desiredCapabilities", session.getRequestedCapabilities()));){
            StringBuilder json = new StringBuilder();
            payload.writeTo((Appendable)json);
            this.request.setBody(json.toString());
            session.forward(this.getRequest(), this.getResponse(), true);
        }
        catch (IOException e) {
            throw new NewSessionException("Error forwarding the request " + e.getMessage(), e);
        }
    }

    protected void forwardRequest(TestSession session, RequestHandler handler) throws IOException {
        session.forward(this.request, this.response, false);
    }

    public void process() {
        switch (this.request.getRequestType()) {
            case START_SESSION: {
                log.info("Got a request to create a new session: " + new DesiredCapabilities(this.request.getDesiredCapabilities()));
                try {
                    this.registry.addNewSessionRequest(this);
                    this.waitForSessionBound();
                    this.beforeSessionEvent();
                    this.forwardNewSessionRequestAndUpdateRegistry(this.session);
                    break;
                }
                catch (Exception e) {
                    this.cleanup();
                    log.log(Level.INFO, "Error forwarding the new session " + e.getMessage(), e);
                    throw new GridException("Error forwarding the new session " + e.getMessage(), e);
                }
            }
            case REGULAR: 
            case STOP_SESSION: {
                this.session = this.getSession();
                if (this.session == null) {
                    ExternalSessionKey sessionKey = null;
                    try {
                        sessionKey = this.request.extractSession();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    throw new GridException("Session [" + sessionKey + "] not available - " + this.registry.getActiveSessions());
                }
                try {
                    this.forwardRequest(this.session, this);
                }
                catch (ClientGoneException e) {
                    log.log(Level.WARNING, "The client is gone for session " + this.session + ", terminating");
                    this.registry.terminate(this.session, SessionTerminationReason.CLIENT_GONE);
                }
                catch (SocketTimeoutException e) {
                    log.log(Level.SEVERE, "Socket timed out for session " + this.session + ", " + e.getMessage());
                    this.registry.terminate(this.session, SessionTerminationReason.SO_TIMEOUT);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "cannot forward the request " + t.getMessage(), t);
                    this.registry.terminate(this.session, SessionTerminationReason.FORWARDING_TO_NODE_FAILED);
                    throw new GridException("cannot forward the request " + t.getMessage(), t);
                }
                if (this.request.getRequestType() != RequestType.STOP_SESSION) break;
                this.registry.terminate(this.session, SessionTerminationReason.CLIENT_STOPPED_SESSION);
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }

    private void cleanup() {
        this.registry.removeNewSessionRequest(this);
        if (this.session != null) {
            this.registry.terminate(this.session, SessionTerminationReason.CREATIONFAILED);
        }
    }

    private void beforeSessionEvent() throws NewSessionException {
        RemoteProxy p = this.session.getSlot().getProxy();
        if (p instanceof TestSessionListener) {
            try {
                ((TestSessionListener)((Object)p)).beforeSession(this.session);
            }
            catch (Exception e) {
                log.severe("Error running the beforeSessionListener : " + e.getMessage());
                e.printStackTrace();
                throw new NewSessionException("The listener threw an exception ( listener bug )", e);
            }
        }
    }

    public void waitForSessionBound() throws InterruptedException, TimeoutException {
        GridHubConfiguration configuration = this.getRegistry().getHub().getConfiguration();
        Integer newSessionWaitTimeout = configuration.newSessionWaitTimeout != null ? configuration.newSessionWaitTimeout : 0;
        if (newSessionWaitTimeout > 0) {
            if (!this.sessionAssigned.await(newSessionWaitTimeout.longValue(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Request timed out waiting for a node to become available.");
            }
        } else {
            this.sessionAssigned.await();
        }
    }

    public SeleniumBasedRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public int compareTo(RequestHandler o) {
        GridHubConfiguration configuration = this.getRegistry().getHub().getConfiguration();
        if (configuration.prioritizer != null) {
            return configuration.prioritizer.compareTo(this.getRequest().getDesiredCapabilities(), o.getRequest().getDesiredCapabilities());
        }
        return 0;
    }

    protected void setSession(TestSession session) {
        this.session = session;
    }

    public void bindSession(TestSession session) {
        this.session = session;
        this.sessionAssigned.countDown();
    }

    public TestSession getSession() {
        if (this.session == null) {
            ExternalSessionKey externalKey = this.request.extractSession();
            this.session = this.registry.getExistingSession(externalKey);
        }
        return this.session;
    }

    public ExternalSessionKey getServerSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getExternalKey();
    }

    public void stop() {
        this.waitingThread.interrupt();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("session:").append(this.session).append(", ");
        b.append("caps: ").append(this.request.getDesiredCapabilities());
        b.append("\n");
        return b.toString();
    }

    public String debug() {
        StringBuilder b = new StringBuilder();
        b.append("\nmethod: ").append(this.request.getMethod());
        b.append("\npathInfo: ").append(this.request.getPathInfo());
        b.append("\nuri: ").append(this.request.getRequestURI());
        b.append("\ncontent :").append(this.request.getBody());
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHandler other = (RequestHandler)obj;
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    public GridRegistry getRegistry() {
        return this.registry;
    }
}

