/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class RegistrationServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -8670670577712086527L;
    private static final Logger log = Logger.getLogger(RegistrationServlet.class.getName());

    public RegistrationServlet() {
        this(null);
    }

    public RegistrationServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
        StringBuilder requestJsonString = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            requestJsonString.append(line);
        }
        rd.close();
        log.fine("getting the following registration request  : " + requestJsonString.toString());
        RegistrationRequest registrationRequest = RegistrationRequest.fromJson(requestJsonString.toString());
        this.considerV2Json(registrationRequest.getConfiguration(), requestJsonString.toString());
        Object proxy = BaseRemoteProxy.getNewInstance(registrationRequest, this.getRegistry());
        this.reply(response, "ok");
        new Thread(new Runnable((RemoteProxy)proxy){
            final /* synthetic */ RemoteProxy val$proxy;
            {
                this.val$proxy = remoteProxy;
            }

            @Override
            public void run() {
                RegistrationServlet.this.getRegistry().add(this.val$proxy);
                log.fine("proxy added " + this.val$proxy.getRemoteHost());
            }
        }).start();
    }

    @Deprecated
    private void considerV2Json(GridNodeConfiguration configuration, String requestJson) {
        JsonObject json = new JsonParser().parse(requestJson).getAsJsonObject();
        if (json.has("id") && (configuration.id == null || configuration.id.isEmpty())) {
            configuration.id = json.get("id").getAsString();
        }
        if (json.has("capabilities") && (configuration.capabilities == null || configuration.capabilities.isEmpty())) {
            JsonArray capabilities = json.get("capabilities").getAsJsonArray();
            for (int i = 0; i < capabilities.size(); ++i) {
                DesiredCapabilities cap = (DesiredCapabilities)new JsonToBeanConverter().convert(DesiredCapabilities.class, (Object)capabilities.get(i));
                configuration.capabilities.add(cap);
            }
        }
    }

    protected void reply(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        response.getWriter().print(content);
    }
}

