/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.common.exception.CapabilityNotPresentOnTheGridException;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.ProxySet;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.listeners.RegistrationListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.internal.HttpClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Registry {
    public static final String KEY = Registry.class.getName();
    private Prioritizer prioritizer = null;
    private static final Logger log = Logger.getLogger(Registry.class.getName());
    private List<RequestHandler> newSessionRequests = new ArrayList<RequestHandler>();
    private Hub hub;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition testSessionAvailable = this.lock.newCondition();
    private final ProxySet proxies = new ProxySet();
    private final Set<TestSession> activeTestSessions = new CopyOnWriteArraySet<TestSession>();
    private Matcher matcherThread = new Matcher();
    private volatile boolean stop = false;
    private boolean throwOnCapabilityNotPresent = true;
    private int newSessionWaitTimeout;
    private final GridHubConfiguration configuration;
    private final HttpClientFactory httpClientFactory;
    private List<RemoteProxy> registeringProxies = new CopyOnWriteArrayList<RemoteProxy>();

    private Registry(Hub hub, GridHubConfiguration config) {
        this.hub = hub;
        this.newSessionWaitTimeout = config.getNewSessionWaitTimeout();
        this.throwOnCapabilityNotPresent = config.isThrowOnCapabilityNotPresent();
        this.prioritizer = config.getPrioritizer();
        this.configuration = config;
        this.httpClientFactory = new HttpClientFactory();
    }

    public static Registry newInstance() {
        return Registry.newInstance(null, new GridHubConfiguration());
    }

    public static Registry newInstance(Hub hub, GridHubConfiguration config) {
        Registry registry = new Registry(hub, config);
        registry.matcherThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                log.log(Level.SEVERE, "Matcher thread dying due to unhandled exception.", e);
            }
        });
        registry.matcherThread.start();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return registry;
    }

    public GridHubConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getNewSessionWaitTimeout() {
        return this.newSessionWaitTimeout;
    }

    public void setNewSessionWaitTimeout(int newSessionWaitTimeout) {
        this.newSessionWaitTimeout = newSessionWaitTimeout;
    }

    public void stop() {
        this.stop = true;
        this.matcherThread.interrupt();
        this.proxies.teardown();
        this.httpClientFactory.close();
    }

    public Hub getHub() {
        return this.hub;
    }

    public void setHub(Hub hub) {
        this.hub = hub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSessionRequest(RequestHandler request) {
        try {
            this.lock.lock();
            if (this.proxies.isEmpty()) {
                if (this.throwOnCapabilityNotPresent) {
                    throw new GridException("Empty pool of VM for setup " + request.getDesiredCapabilities());
                }
                log.warning("Empty pool of nodes.");
            }
            if (!this.proxies.hasCapability(request.getDesiredCapabilities())) {
                if (this.throwOnCapabilityNotPresent) {
                    throw new CapabilityNotPresentOnTheGridException(request.getDesiredCapabilities());
                }
                log.warning("grid doesn't contain " + request.getDesiredCapabilities() + " at the moment.");
            }
            this.newSessionRequests.add(request);
            this.fireEventNewSessionAvailable();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void assignRequestToProxy() {
        boolean force = false;
        while (!this.stop) {
            try {
                this.matcherThread.registryHasBeenModified(true);
                if (force) {
                    force = false;
                } else {
                    this.testSessionAvailable.await(5L, TimeUnit.SECONDS);
                }
                if (this.prioritizer != null) {
                    Collections.sort(this.newSessionRequests);
                }
                ArrayList<RequestHandler> matched = new ArrayList<RequestHandler>();
                block5: for (RequestHandler request : this.newSessionRequests) {
                    List<RemoteProxy> sorted = this.proxies.getSorted();
                    for (RemoteProxy proxy : sorted) {
                        if (!this.matcherThread.isRegistryClean()) {
                            throw new QueueIsStateException();
                        }
                        TestSession session = proxy.getNewSession(request.getDesiredCapabilities());
                        if (session == null) continue;
                        if (!this.matcherThread.isRegistryClean()) {
                            throw new QueueIsStateException();
                        }
                        matched.add(request);
                        boolean ok = this.activeTestSessions.add(session);
                        request.bindSession(session);
                        if (ok) continue block5;
                        log.severe("Error adding session : " + session);
                        continue block5;
                    }
                }
                for (RequestHandler req : matched) {
                    boolean ok = this.removeNewSessionRequest(req);
                    if (ok) continue;
                    log.severe("Bug removing request " + req);
                }
            }
            catch (InterruptedException e) {
                log.info("Shutting down registry.");
            }
            catch (QueueIsStateException q) {
                log.fine("something modified the queue while the matcher was looking at it.Restarting the iteration from 0.");
                force = true;
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unhandled exception in Matcher thread.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(TestSession session) {
        try {
            this.lock.lock();
            this.matcherThread.registryHasBeenModified(false);
            boolean removed = this.activeTestSessions.remove(session);
            if (removed) {
                this.fireEventNewSessionAvailable();
            }
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void release(String internalKey) {
        if (internalKey == null) {
            return;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!internalKey.equals(session.getInternalKey())) continue;
            this.release(session);
            return;
        }
        log.warning("Tried to release session with internal key " + internalKey + " but couldn't find it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RemoteProxy proxy) {
        if (proxy == null) {
            return;
        }
        log.fine("adding  " + proxy);
        try {
            this.lock.lock();
            this.proxies.removeIfPresent(proxy);
            if (this.registeringProxies.contains(proxy)) {
                log.warning(String.format("Proxy '%s' is already queued for registration.", proxy));
                Object var3_2 = null;
                this.lock.unlock();
                return;
            }
            this.registeringProxies.add(proxy);
            this.matcherThread.registryHasBeenModified(false);
            this.fireEventNewSessionAvailable();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_3 = null;
        this.lock.unlock();
        boolean listenerOk = true;
        try {
            if (proxy instanceof RegistrationListener) {
                ((RegistrationListener)((Object)proxy)).beforeRegistration();
            }
        }
        catch (Throwable t) {
            log.severe("Error running the registration listener on " + proxy + ", " + t.getMessage());
            t.printStackTrace();
            listenerOk = false;
        }
        try {
            this.lock.lock();
            this.registeringProxies.remove(proxy);
            if (listenerOk) {
                if (proxy instanceof SelfHealingProxy) {
                    ((SelfHealingProxy)((Object)proxy)).startPolling();
                }
                this.proxies.add(proxy);
                this.fireEventNewSessionAvailable();
            }
            Object var5_8 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public Lock getLock() {
        return this.lock;
    }

    void fireEventNewSessionAvailable() {
        this.testSessionAvailable.signalAll();
    }

    public ProxySet getAllProxies() {
        return this.proxies;
    }

    public List<RemoteProxy> getUsedProxies() {
        return this.proxies.getBusyProxies();
    }

    public TestSession getSession(String externalKey) {
        if (externalKey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!externalKey.equals(session.getExternalKey())) continue;
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewSessionRequestCount() {
        try {
            this.lock.lock();
            int n = this.newSessionRequests.size();
            Object var3_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestHandler> clearNewSessionRequests() {
        try {
            this.lock.lock();
            List<RequestHandler> list = this.newSessionRequests;
            Object var3_2 = null;
            this.lock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNewSessionRequest(RequestHandler request) {
        try {
            this.lock.lock();
            boolean bl = this.newSessionRequests.remove(request);
            Object var4_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestHandler> getNewSessionRequests() {
        try {
            this.lock.lock();
            ArrayList<RequestHandler> arrayList = new ArrayList<RequestHandler>(this.newSessionRequests);
            Object var3_2 = null;
            this.lock.unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public Set<TestSession> getActiveSessions() {
        return this.activeTestSessions;
    }

    public void setPrioritizer(Prioritizer prioritizer) {
        this.prioritizer = prioritizer;
    }

    public Prioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public RemoteProxy getProxyById(String id) {
        if (id == null) {
            return null;
        }
        for (RemoteProxy p : this.getAllProxies()) {
            if (!id.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    class QueueIsStateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        QueueIsStateException() {
        }
    }

    class Matcher
    extends Thread {
        private volatile boolean cleanState = true;

        Matcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Registry.this.lock.lock();
                Registry.this.assignRequestToProxy();
                Object var2_1 = null;
                Registry.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Registry.this.lock.unlock();
                throw throwable;
            }
        }

        public void registryHasBeenModified(boolean ok) {
            this.cleanState = ok;
        }

        public boolean isRegistryClean() {
            return this.cleanState;
        }
    }
}

