/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.grid.common.exception.GridConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOptionHelper {
    private String[] args;

    private CommandLineOptionHelper() {
    }

    public CommandLineOptionHelper(String[] args) {
        this.args = args;
    }

    public boolean isParamPresent(String name) {
        for (String arg : this.args) {
            if (!name.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public String getParamValue(String name) {
        int index = -1;
        for (int i = 0; i < this.args.length; ++i) {
            if (!name.equals(this.args[i])) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new GridConfigurationException("The parameter " + name + " isn't specified.");
        }
        if (this.args.length == index) {
            throw new GridConfigurationException("The parameter " + name + " doesn't have a value specified.");
        }
        return this.args[index + 1];
    }

    public List<String> getParamValues(String name) {
        if (this.isParamPresent(name)) {
            String value = this.getParamValue(name);
            return Arrays.asList(value.split(","));
        }
        return new ArrayList<String>();
    }

    public List<String> getAll(String name) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.args.length; ++i) {
            if (!name.equals(this.args[i])) continue;
            res.add(this.args[i + 1]);
        }
        return res;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String arg : this.args) {
            if (!arg.startsWith("-")) continue;
            keys.add(arg);
        }
        return keys;
    }
}

