/*
 * Decompiled with CFR 0.152.
 */
package cybervillains.ca;

import cybervillains.ca.CertificateCreator;
import cybervillains.ca.ThumbprintUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.DSAParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openqa.selenium.server.security.CertificateGenerator;
import org.openqa.selenium.server.security.KeyAndCert;

public class KeyStoreManager {
    static Logger log = Logger.getLogger(KeyStoreManager.class.getName());
    private final String CERTMAP_SER_FILE = "certmap.ser";
    private final String SUBJMAP_SER_FILE = "subjmap.ser";
    private final String EXPORTED_CERT_NAME = "cybervillainsCA.cer";
    private final char[] _keypassword = "password".toCharArray();
    private final char[] _keystorepass = "password".toCharArray();
    private final String _caPrivateKeystore = "cybervillainsCA.jks";
    private final String _caCertAlias = "signingCert";
    public static final String _caPrivKeyAlias = "signingCertPrivKey";
    X509Certificate _caCert;
    PrivateKey _caPrivKey;
    KeyStore _ks;
    private HashMap<PublicKey, PrivateKey> _rememberedPrivateKeys;
    private HashMap<PublicKey, PublicKey> _mappedPublicKeys;
    private HashMap<String, String> _certMap;
    private HashMap<String, String> _subjectMap;
    private final String KEYMAP_SER_FILE = "keymap.ser";
    private final String PUB_KEYMAP_SER_FILE = "pubkeymap.ser";
    public final String RSA_KEYGEN_ALGO = "RSA";
    public final String DSA_KEYGEN_ALGO = "DSA";
    public final KeyPairGenerator _rsaKpg;
    public final KeyPairGenerator _dsaKpg;
    private boolean persistImmediately = true;
    private File root;
    private final String certificateRevocationList;

    public KeyStoreManager(File root, String certificateRevocationList) {
        ObjectInputStream in;
        File file;
        this.root = root;
        this.certificateRevocationList = certificateRevocationList;
        BouncyCastleProvider bcProv = new BouncyCastleProvider();
        DHParameterSpec dhSpec512 = new DHParameterSpec(new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16), new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16), 384);
        DHParameterSpec dhSpec768 = new DHParameterSpec(new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16), new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16), 384);
        DHParameterSpec dhSpec1024 = new DHParameterSpec(new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16), new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16), 512);
        bcProv.setParameter("DhDefaultParams", (Object)new DHParameterSpec[]{dhSpec512, dhSpec768, dhSpec1024});
        Security.insertProviderAt((Provider)bcProv, 2);
        SecureRandom _sr = new SecureRandom();
        try {
            this._rsaKpg = KeyPairGenerator.getInstance("RSA");
            this._dsaKpg = KeyPairGenerator.getInstance("DSA");
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        try {
            File privKeys = new File(root, "keymap.ser");
            if (!privKeys.exists()) {
                this._rememberedPrivateKeys = new HashMap();
            } else {
                ObjectInputStream in2 = new ObjectInputStream(new FileInputStream(privKeys));
                this._rememberedPrivateKeys = (HashMap)in2.readObject();
                in2.close();
            }
            File pubKeys = new File(root, "pubkeymap.ser");
            if (!pubKeys.exists()) {
                this._mappedPublicKeys = new HashMap();
            } else {
                ObjectInputStream in3 = new ObjectInputStream(new FileInputStream(pubKeys));
                this._mappedPublicKeys = (HashMap)in3.readObject();
                in3.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        BigInteger p = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger q = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
        BigInteger g = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        DSAParameterSpec dsaParameterSpec = new DSAParameterSpec(p, q, g);
        this._rsaKpg.initialize(1024, _sr);
        try {
            this._dsaKpg.initialize(dsaParameterSpec, _sr);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            this._dsaKpg.initialize(1024, _sr);
        }
        try {
            this._ks = KeyStore.getInstance("JKS");
            this.reloadKeystore();
        }
        catch (FileNotFoundException fnfe) {
            try {
                this.createKeystore();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            file = new File(root, "certmap.ser");
            if (!file.exists()) {
                this._certMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this._certMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            file = new File(root, "subjmap.ser");
            if (!file.exists()) {
                this._subjectMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this._subjectMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private void reloadKeystore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        FileInputStream is = new FileInputStream(new File(this.root, "cybervillainsCA.jks"));
        this._ks.load(is, this._keystorepass);
        this._caCert = (X509Certificate)this._ks.getCertificate("signingCert");
        this._caPrivKey = (PrivateKey)this._ks.getKey(_caPrivKeyAlias, this._keypassword);
    }

    protected void createKeystore() {
        if (this._caCert == null || this._caPrivKey == null) {
            try {
                log.fine("Keystore or signing cert & keypair not found.  Generating...");
                KeyPair caKeypair = this.getRSAKeyPair();
                PrivateKey caPrivKey = caKeypair.getPrivate();
                X509Certificate signingCert = CertificateCreator.createTypicalMasterCert(caKeypair);
                log.fine("Done generating signing cert");
                log.fine(String.valueOf(signingCert));
                this._ks.load(null, this._keystorepass);
                this._ks.setCertificateEntry("signingCert", signingCert);
                this._ks.setKeyEntry(_caPrivKeyAlias, caPrivKey, this._keypassword, new Certificate[]{signingCert});
                File caKsFile = new File(this.root, "cybervillainsCA.jks");
                FileOutputStream os = new FileOutputStream(caKsFile);
                this._ks.store(os, this._keystorepass);
                log.fine("Wrote JKS keystore to: " + caKsFile.getAbsolutePath());
                File signingCertFile = new File(this.root, "cybervillainsCA.cer");
                FileOutputStream cerOut = new FileOutputStream(signingCertFile);
                byte[] buf = signingCert.getEncoded();
                log.fine("Wrote signing cert to: " + signingCertFile.getAbsolutePath());
                cerOut.write(buf);
                cerOut.flush();
                cerOut.close();
                this._caCert = signingCert;
                this._caPrivKey = caPrivKey;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Fatal error creating/storing keystore or signing cert.", e);
                throw new Error(e);
            }
        } else {
            log.fine("Successfully loaded keystore.");
            log.fine(String.valueOf(this._caCert));
        }
    }

    public synchronized void addCertAndPrivateKey(String hostname, X509Certificate cert, PrivateKey privKey) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        this._ks.deleteEntry(hostname);
        this._ks.setCertificateEntry(hostname, cert);
        this._ks.setKeyEntry(hostname, privKey, this._keypassword, new Certificate[]{cert});
        if (this.persistImmediately) {
            this.persist();
        }
    }

    public synchronized void persist() throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream kso = null;
        try {
            kso = new FileOutputStream(new File(this.root, "cybervillainsCA.jks"));
            this._ks.store(kso, this._keystorepass);
            kso.flush();
            kso.close();
            this.persistCertMap();
            this.persistSubjectMap();
            this.persistKeyPairMap();
            this.persistPublicKeyMap();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (kso != null) {
                try {
                    kso.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Unable to close cybervillainsCA.jks", e);
                }
            }
        }
    }

    public synchronized X509Certificate getCertificateByAlias(String alias) throws KeyStoreException {
        return (X509Certificate)this._ks.getCertificate(alias);
    }

    public synchronized X509Certificate getCertificateByHostname(String hostname) throws KeyStoreException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String alias = this._subjectMap.get(this.getSubjectForHostname(hostname));
        if (alias != null) {
            return (X509Certificate)this._ks.getCertificate(alias);
        }
        return this.getMappedCertificateForHostname(hostname);
    }

    public synchronized X509Certificate getSigningCert() throws KeyStoreException {
        return this._caCert;
    }

    public synchronized PrivateKey getSigningPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this._caPrivKey;
    }

    public X509Certificate getMappedCertificateForHostname(String hostname) throws InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException {
        String subject = this.getSubjectForHostname(hostname);
        String thumbprint = this._subjectMap.get(subject);
        if (thumbprint == null) {
            KeyAndCert keyAndCert = new CertificateGenerator(this.root).generateCertificate(hostname, this.certificateRevocationList);
            X509Certificate newCert = keyAndCert.getCertificate();
            this.addCertAndPrivateKey(hostname, newCert, keyAndCert.getPrivateKey());
            thumbprint = ThumbprintUtil.getThumbprint(newCert);
            this._subjectMap.put(subject, thumbprint);
            if (this.persistImmediately) {
                this.persist();
            }
            return newCert;
        }
        return this.getCertificateByAlias(thumbprint);
    }

    private String getSubjectForHostname(String hostname) {
        return "CN=" + hostname + ", OU=Test, O=CyberVillainsCA, L=Seattle, S=Washington, C=US";
    }

    private synchronized void persistCertMap() {
        this.persistMap(new File(this.root, "certmap.ser"), this._certMap);
    }

    private synchronized void persistSubjectMap() {
        this.persistMap(new File(this.root, "subjmap.ser"), this._subjectMap);
    }

    public KeyPair getRSAKeyPair() {
        KeyPair kp = this._rsaKpg.generateKeyPair();
        this.rememberKeyPair(kp);
        return kp;
    }

    private synchronized void persistPublicKeyMap() {
        this.persistMap(new File(this.root, "pubkeymap.ser"), this._mappedPublicKeys);
    }

    private synchronized void persistKeyPairMap() {
        this.persistMap(new File(this.root, "keymap.ser"), this._rememberedPrivateKeys);
    }

    private void persistMap(File outputFile, Map<?, ?> toPersist) {
        ObjectOutput out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(toPersist);
            out.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Unable to close " + outputFile.getName(), e);
                }
            }
        }
    }

    private synchronized void rememberKeyPair(KeyPair kp) {
        this._rememberedPrivateKeys.put(kp.getPublic(), kp.getPrivate());
        if (this.persistImmediately) {
            this.persistKeyPairMap();
        }
    }

    public KeyStore getKeyStore() {
        return this._ks;
    }
}

