/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.Clock;
import org.openqa.selenium.remote.server.DefaultDriverFactory;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DefaultSession;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SystemClock;

public class DefaultDriverSessions
implements DriverSessions {
    private static final Logger LOG = Logger.getLogger(DefaultDriverSessions.class.getName());
    private final DriverFactory factory;
    private final Clock clock;
    private final Map<SessionId, Session> sessionIdToDriver = new ConcurrentHashMap<SessionId, Session>();
    private static List<DriverProvider> defaultDriverProviders = new ImmutableList.Builder().add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.chrome(), "org.openqa.selenium.chrome.ChromeDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.firefox(), "org.openqa.selenium.firefox.FirefoxDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.internetExplorer(), "org.openqa.selenium.ie.InternetExplorerDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.edge(), "org.openqa.selenium.edge.EdgeDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.opera(), "com.opera.core.systems.OperaDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.operaBlink(), "org.openqa.selenium.opera.OperaDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.safari(), "org.openqa.selenium.safari.SafariDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.phantomjs(), "org.openqa.selenium.phantomjs.PhantomJSDriver")).add((Object)new DefaultDriverProvider((Capabilities)DesiredCapabilities.htmlUnit(), "org.openqa.selenium.htmlunit.HtmlUnitDriver")).build();

    public DefaultDriverSessions() {
        this(Platform.getCurrent(), new DefaultDriverFactory());
    }

    public DefaultDriverSessions(DriverFactory factory) {
        this(Platform.getCurrent(), factory);
    }

    protected DefaultDriverSessions(Platform runningOn, DriverFactory factory) {
        this(runningOn, factory, new SystemClock());
    }

    protected DefaultDriverSessions(Platform runningOn, DriverFactory factory, Clock clock) {
        this.factory = factory;
        this.clock = clock;
        this.registerDefaults(runningOn);
        this.registerServiceLoaders(runningOn);
    }

    private void registerDefaults(Platform current) {
        for (DriverProvider provider : defaultDriverProviders) {
            this.registerDriverProvider(current, provider);
        }
    }

    private void registerServiceLoaders(Platform current) {
        for (DriverProvider provider : ServiceLoader.load(DriverProvider.class)) {
            this.registerDriverProvider(current, provider);
        }
    }

    private void registerDriverProvider(Platform current, DriverProvider provider) {
        Capabilities caps = provider.getProvidedCapabilities();
        if (!this.platformMatches(current, caps)) {
            LOG.info(String.format("Driver provider %s registration is skipped:%nregistration capabilities %s does not match the current platform %s", provider, caps, current));
            return;
        }
        this.factory.registerDriverProvider(provider);
    }

    private boolean platformMatches(Platform current, Capabilities caps) {
        return caps.getPlatform() == null || caps.getPlatform() == Platform.ANY || current.is(caps.getPlatform());
    }

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> driverClass) {
        this.factory.registerDriverProvider(new DefaultDriverProvider(capabilities, driverClass));
    }

    @Override
    public SessionId newSession(Capabilities desiredCapabilities) throws Exception {
        SessionId sessionId = new SessionId(UUID.randomUUID().toString());
        Session session = DefaultSession.createSession(this.factory, this.clock, sessionId, desiredCapabilities);
        this.sessionIdToDriver.put(sessionId, session);
        return sessionId;
    }

    @Override
    public Session get(SessionId sessionId) {
        return this.sessionIdToDriver.get(sessionId);
    }

    @Override
    public void deleteSession(SessionId sessionId) {
        Session removedSession = this.sessionIdToDriver.remove(sessionId);
        if (removedSession != null) {
            removedSession.close();
        }
    }

    @Override
    public Set<SessionId> getSessions() {
        return Collections.unmodifiableSet(this.sessionIdToDriver.keySet());
    }
}

