/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.net.URL;
import org.openqa.selenium.remote.server.HttpRequest;
import org.openqa.selenium.remote.server.HttpResponse;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class ResourceCopyResult
implements Renderer {
    private static final ImmutableMap<String, MediaType> MIME_TYPES = ImmutableMap.of((Object)"css", (Object)MediaType.CSS_UTF_8.withoutParameters(), (Object)"html", (Object)MediaType.HTML_UTF_8.withoutParameters(), (Object)"js", (Object)MediaType.JAVASCRIPT_UTF_8.withoutParameters());
    private final String propertyName;

    public ResourceCopyResult(String propertyName) {
        this.propertyName = propertyName.startsWith(":") ? propertyName.substring(1) : propertyName;
    }

    @Override
    public void render(HttpRequest request, HttpResponse response, RestishHandler handler) throws Exception {
        String extension;
        URL resource = (URL)request.getAttribute(this.propertyName);
        if (resource == null) {
            response.setStatus(404);
            return;
        }
        String fileName = resource.getFile();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex >= 0 && MIME_TYPES.containsKey((Object)(extension = fileName.substring(dotIndex + 1)))) {
            response.setContentType(((MediaType)MIME_TYPES.get((Object)extension)).toString());
        }
        response.setStatus(200);
        response.setContent(ByteStreams.toByteArray((InputStream)resource.openStream()));
    }
}

