/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import cybervillains.ca.KeyStoreManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.HttpServer;
import org.openqa.jetty.http.HttpTunnel;
import org.openqa.jetty.http.SslListener;
import org.openqa.jetty.http.handler.AbstractHttpHandler;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.InetAddrPort;
import org.openqa.jetty.util.StringMap;
import org.openqa.jetty.util.URI;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ModifiedIO;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.TrustEverythingSSLTrustManager;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.commands.AddCustomRequestHeaderCommand;
import org.openqa.selenium.server.commands.CaptureNetworkTrafficCommand;

public class ProxyHandler
extends AbstractHttpHandler {
    private static Logger log = Logger.getLogger(ProxyHandler.class.getName());
    protected Set<String> _proxyHostsWhiteList;
    protected Set<String> _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 250;
    private transient boolean _chained = false;
    private final Map<String, SslRelay> _sslMap = new LinkedHashMap<String, SslRelay>();
    private String sslKeystorePath;
    private boolean trustAllSSLCertificates = false;
    private final String dontInjectRegex;
    private final String debugURL;
    private final boolean proxyInjectionMode;
    private final boolean forceProxyChain;
    private boolean fakeCertsGenerated;
    private final Object shutdownLock;
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxyAuthHeaders;
    protected StringMap _ProxySchemes;
    protected HashSet<Integer> _allowedConnectPorts;
    private int port;

    public ProxyHandler(boolean trustAllSSLCertificates, String dontInjectRegex, String debugURL, boolean proxyInjectionMode, boolean forceProxyChain, int port, Object shutdownLock) {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Upgrade", o);
        this._ProxyAuthHeaders = new StringMap();
        o = new Object();
        this._ProxyAuthHeaders.put("Proxy-Authorization", o);
        this._ProxyAuthHeaders.put("Proxy-Authenticate", o);
        this._ProxySchemes = new StringMap();
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(80);
        this._allowedConnectPorts.add(RemoteControlConfiguration.getDefaultPort());
        this._allowedConnectPorts.add(8000);
        this._allowedConnectPorts.add(8080);
        this._allowedConnectPorts.add(8888);
        this._allowedConnectPorts.add(443);
        this._allowedConnectPorts.add(8443);
        this.trustAllSSLCertificates = trustAllSSLCertificates;
        this.dontInjectRegex = dontInjectRegex;
        this.debugURL = debugURL;
        this.proxyInjectionMode = proxyInjectionMode;
        this.forceProxyChain = forceProxyChain;
        this.port = port;
        this.shutdownLock = shutdownLock;
    }

    @Override
    public void start() throws Exception {
        this._chained = System.getProperty("http.proxyHost") != null || this.forceProxyChain;
        super.start();
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        block10: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                response.setField("Connection", "close");
                this.handleConnect(request, response);
                return;
            }
            try {
                if ("True".equals(response.getAttribute("NotFound"))) {
                    response.removeAttribute("NotFound");
                    this.sendNotFound(response);
                    return;
                }
                URL url = this.isProxied(uri);
                if (url == null) {
                    if (this.isForbidden(uri)) {
                        this.sendForbid(response);
                    }
                    return;
                }
                if (this.isSeleniumUrl(url.toString())) {
                    request.setHandled(false);
                    return;
                }
                this.proxyPlainTextRequest(url, request, response);
            }
            catch (UnknownHostException e) {
                log.info("Couldn't proxy to " + uri + " because host not found");
                response.setStatus(400);
                String host = uri.getHost();
                response.setReason("Host " + host + " not found");
                OutputStreamWriter out = new OutputStreamWriter(response.getOutputStream());
                out.write("<html><head><title>Problem loading page</title></head><body style=\"background-color:#F0F0F0; font-family: sans-serif\"><div style=\"margin:auto; margin-top: 3em;width:600px; background-color:#FFF; padding:30px;border: 1px solid #DDD\"><h1 style=\"font-size: 18px;border-bottom:thin solid #DDD\">Server not found</h1><p style=\"border-bottom: 1px solid #DDD; padding-bottom: 20px\">Selenium can't find the server at " + host + "</p>" + "<ul style=\"list-style: square outside none;font-size:13px\">" + "<li style=\"margin-bottom:6px;\">Check the address for typing errors such as ww.example.com instead of www.example.com</li>" + "<li style=\"margin-bottom:6px;\">If you are unable to load any pages, check your computer's network connection.</li>" + "<li style=\"margin-bottom:6px;\">If your computer or network is protected by a firewall or proxy, make sure that your browser is permitted to access the Web.</li>" + "</ul>" + "</div>" + "</body>");
                out.close();
                response.getOutputStream().close();
            }
            catch (ConnectException e) {
                log.info("Couldn't proxy to " + uri + " because host not listening");
                response.setStatus(400);
                String host = uri.getHost();
                if (uri.getPort() > 0) {
                    host = host + ":" + uri.getPort();
                }
                response.setReason("Couldn't connect to " + host);
                OutputStreamWriter out = new OutputStreamWriter(response.getOutputStream());
                out.write("<html><head><title>Problem loading page</title></head><body style=\"background-color:#F0F0F0; font-family: sans-serif\"><div style=\"margin:auto; margin-top: 3em;width:600px; background-color:#FFF; padding:30px;border: 1px solid #DDD\"><h1 style=\"font-size: 18px;border-bottom:thin solid #DDD\">Unable to connect</h1><p style=\"border-bottom: 1px solid #DDD; padding-bottom: 20px\">Selenium can't establish a connection to the server at " + host + "</p>" + "<ul style=\"list-style: square outside none;font-size:13px\">" + "<li style=\"margin-bottom:6px;\">The site could be temporarily unavailable or too busy. Try again in a few moments.</li>" + "<li style=\"margin-bottom:6px;\">If you are unable to load any pages, check your computer's network connection.</li>" + "<li style=\"margin-bottom:6px;\">If your computer or network is protected by a firewall or proxy, make sure that your browser is permitted to access the Web.</li>" + "</ul>" + "</div>" + "</body>");
                out.close();
                response.getOutputStream().close();
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not proxy " + uri, e);
                if (response.isCommitted()) break block10;
                response.sendError(400, "Could not proxy " + uri + "\n" + e);
            }
        }
    }

    private boolean isSeleniumUrl(String url) {
        int slashSlash = url.indexOf("//");
        if (slashSlash == -1) {
            return false;
        }
        int nextSlash = url.indexOf("/", slashSlash + 2);
        if (nextSlash == -1) {
            return false;
        }
        int seleniumServer = url.indexOf("/selenium-server/");
        if (seleniumServer == -1) {
            return false;
        }
        return seleniumServer == nextSlash;
    }

    protected long proxyPlainTextRequest(URL url, HttpRequest request, HttpResponse response) throws IOException {
        String cache_control;
        String connectionHdr;
        CaptureNetworkTrafficCommand.Entry entry = new CaptureNetworkTrafficCommand.Entry(request.getMethod(), url.toString());
        entry.addRequestHeaders(request);
        log.fine("PROXY URL=" + url);
        URLConnection connection = url.openConnection();
        if (System.getProperty("http.proxyHost") != null && System.getProperty("https.proxyHost") == null && "https".equals(url.getProtocol())) {
            String proxyHost = System.getProperty("http.proxyHost");
            int proxyPort = Integer.getInteger("http.proxyPort");
            InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
            connection = url.openConnection(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        connection.setAllowUserInteraction(false);
        if (this.proxyInjectionMode) {
            this.adjustRequestForProxyInjection(request, connection);
        }
        HttpURLConnection http = null;
        if (connection instanceof HttpURLConnection) {
            http = (HttpURLConnection)connection;
            http.setRequestMethod(request.getMethod());
            http.setInstanceFollowRedirects(false);
            if (this.trustAllSSLCertificates && connection instanceof HttpsURLConnection) {
                TrustEverythingSSLTrustManager.trustAllSSLCertificates((HttpsURLConnection)connection);
            }
        }
        if ((connectionHdr = request.getField("Connection")) != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
            connectionHdr = null;
        }
        boolean xForwardedFor = false;
        boolean isGet = "GET".equals(request.getMethod());
        boolean hasContent = false;
        Enumeration enm = request.getFieldNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            if (this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr) || connectionHdr != null && connectionHdr.contains(hdr)) continue;
            if (!isGet && "Content-Type".equals(hdr)) {
                hasContent = true;
            }
            Enumeration vals = request.getFieldValues(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null || "Referer".equals(hdr) && val.contains("/selenium-server/")) continue;
                if (!isGet && "Content-Length".equals(hdr) && Integer.parseInt(val) > 0) {
                    hasContent = true;
                }
                connection.addRequestProperty(hdr, val);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
            }
        }
        Map<String, String> customRequestHeaders = AddCustomRequestHeaderCommand.getHeaders();
        for (Map.Entry<String, String> e : customRequestHeaders.entrySet()) {
            connection.addRequestProperty(e.getKey(), e.getValue());
            entry.addRequestHeader(e.getKey(), e.getValue());
        }
        connection.setRequestProperty("Via", "1.1 (jetty)");
        if (!xForwardedFor) {
            connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
        }
        if ((cache_control = request.getField("Cache-Control")) != null && (cache_control.contains("no-cache") || cache_control.contains("no-store"))) {
            connection.setUseCaches(false);
        }
        try {
            connection.setDoInput(true);
            InputStream in = request.getInputStream();
            if (hasContent) {
                connection.setDoOutput(true);
                IO.copy(in, connection.getOutputStream());
            }
            connection.connect();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        InputStream proxy_in = null;
        int code = -1;
        if (http != null) {
            proxy_in = http.getErrorStream();
            try {
                code = http.getResponseCode();
            }
            catch (SSLHandshakeException e) {
                throw new RuntimeException("Couldn't establish SSL handshake.  Try using trustAllSSLCertificates.\n" + e.getLocalizedMessage(), e);
            }
            response.setStatus(code);
            response.setReason(http.getResponseMessage());
            String contentType = http.getContentType();
            log.fine("Content-Type is: " + contentType);
        }
        if (proxy_in == null) {
            try {
                proxy_in = connection.getInputStream();
            }
            catch (Exception e) {
                proxy_in = http.getErrorStream();
            }
        }
        response.removeField("Date");
        response.removeField("Server");
        int h = 0;
        String hdr = connection.getHeaderFieldKey(h);
        String val = connection.getHeaderField(h);
        while (hdr != null || val != null) {
            if (!(hdr == null || val == null || this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr))) {
                response.addField(hdr, val);
            }
            hdr = connection.getHeaderFieldKey(++h);
            val = connection.getHeaderField(h);
        }
        response.setField("Via", "1.1 (jetty)");
        response.removeField("ETag");
        response.removeField("Last-Modified");
        long bytesCopied = -1L;
        request.setHandled(true);
        if (proxy_in != null) {
            boolean injectableResponse;
            boolean bl = injectableResponse = http.getResponseCode() == 200 || http.getResponseCode() >= 400 && http.getResponseCode() < 600;
            bytesCopied = this.proxyInjectionMode && injectableResponse ? (this.shouldInject(request.getPath()) ? InjectionHelper.injectJavaScript(request, response, proxy_in, response.getOutputStream(), this.debugURL) : ModifiedIO.copy(proxy_in, response.getOutputStream())) : ModifiedIO.copy(proxy_in, response.getOutputStream());
        }
        entry.finish(code, bytesCopied);
        entry.addResponseHeader(response);
        CaptureNetworkTrafficCommand.capture(entry);
        return bytesCopied;
    }

    public boolean shouldInject(String path) {
        return this.dontInjectRegex == null || !path.matches(this.dontInjectRegex);
    }

    private void adjustRequestForProxyInjection(HttpRequest request, URLConnection connection) {
        request.setState(0);
        if (request.containsField("If-Modified-Since")) {
            request.removeField("If-Modified-Since");
            request.removeField("If-None-Match");
            connection.setUseCaches(false);
        }
        request.removeField("Accept-Encoding");
        request.setState(2);
    }

    public synchronized void generateSSLCertsForLoggingHosts(HttpServer server) {
        if (this.fakeCertsGenerated) {
            return;
        }
        log.info("Creating 16 fake SSL servers for browser side logging");
        for (int i = 1; i <= 16; ++i) {
            String uri = i + ".selenium.doesnotexist:443";
            try {
                this.getSslRelayOrCreateNew(new URI(uri), new InetAddrPort(443), server);
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not pre-create logging SSL relay for " + uri, e);
            }
        }
        this.fakeCertsGenerated = true;
    }

    public void handleConnect(HttpRequest request, HttpResponse response) throws IOException {
        URI uri = request.getURI();
        try {
            log.fine("CONNECT: " + uri);
            InetAddrPort addrPort = uri.toString().endsWith(".selenium.doesnotexist:443") ? new InetAddrPort(443) : new InetAddrPort(uri.toString());
            if (this.isForbidden("https", addrPort.getHost())) {
                this.sendForbid(response);
            } else {
                HttpTunnel tunnel;
                HttpConnection http_connection = request.getHttpConnection();
                http_connection.forceClose();
                HttpServer server = http_connection.getHttpServer();
                SslRelay listener = this.getSslRelayOrCreateNew(uri, addrPort, server);
                int port = listener.getPort();
                int timeoutMs = 30000;
                Object maybesocket = http_connection.getConnection();
                if (maybesocket instanceof Socket) {
                    Socket s = (Socket)maybesocket;
                    timeoutMs = s.getSoTimeout();
                }
                if ((tunnel = this.newHttpTunnel(response, InetAddress.getByName(null), port, timeoutMs)) != null) {
                    if (this._tunnelTimeoutMs > 0) {
                        tunnel.getSocket().setSoTimeout(this._tunnelTimeoutMs);
                        if (maybesocket instanceof Socket) {
                            Socket s = (Socket)maybesocket;
                            s.setSoTimeout(this._tunnelTimeoutMs);
                        }
                    }
                    tunnel.setTimeoutMs(timeoutMs);
                    request.getHttpConnection().setHttpTunnel(tunnel);
                    response.setStatus(200);
                    response.setContentLength(0);
                }
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "error during handleConnect", e);
            response.sendError(500, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SslRelay getSslRelayOrCreateNew(URI uri, InetAddrPort addrPort, HttpServer server) throws Exception {
        SslRelay listener;
        Map<String, SslRelay> map = this._sslMap;
        synchronized (map) {
            listener = this._sslMap.get(uri.toString());
            if (listener == null) {
                String host = new URL("https://" + uri.toString()).getHost();
                listener = new SslRelay(addrPort);
                this.wireUpSslWithCyberVilliansCA(host, listener);
                listener.setPassword("password");
                listener.setKeyPassword("password");
                server.addListener(listener);
                Object object = this.shutdownLock;
                synchronized (object) {
                    try {
                        if (!server.isStarted()) {
                            throw new RuntimeException("Can't start SslRelay: server is not started (perhaps it was just shut down?)");
                        }
                        listener.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                this._sslMap.put(uri.toString(), listener);
            }
        }
        return listener;
    }

    protected void wireUpSslWithCyberVilliansCA(String host, SslRelay listener) {
        try {
            File root = File.createTempFile("seleniumSslSupport", host);
            root.delete();
            root.mkdirs();
            ResourceExtractor.extractResourcePath(this.getClass(), "/sslSupport", root);
            KeyStoreManager mgr = new KeyStoreManager(root, "http://127.0.0.1:" + this.port + "/selenium-server/sslSupport/blank_crl.pem");
            mgr.getCertificateByHostname(host);
            mgr.getKeyStore().deleteEntry("signingCertPrivKey");
            mgr.persist();
            listener.setKeystore(new File(root, "cybervillainsCA.jks").getAbsolutePath());
            listener.setNukeDirOrFile(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpTunnel newHttpTunnel(HttpResponse response, InetAddress iaddr, int port, int timeoutMS) throws IOException {
        try {
            Socket socket = new Socket(iaddr, port);
            socket.setSoTimeout(timeoutMS);
            socket.setTcpNoDelay(true);
            return new HttpTunnel(socket, null, null);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Exception thrown", e);
            response.sendError(400);
            return null;
        }
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        if (this.isForbidden(uri)) {
            return null;
        }
        return new URL(uri.toString());
    }

    protected boolean isForbidden(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return this.isForbidden(scheme, host);
    }

    protected boolean isForbidden(String scheme, String host) {
        if (scheme == null || !this._ProxySchemes.containsKey(scheme)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(host)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(host);
    }

    protected void sendForbid(HttpResponse response) throws IOException {
        response.sendError(403, "Forbidden for Proxy");
    }

    protected void sendNotFound(HttpResponse response) throws IOException {
        response.sendError(404, "Not found");
    }

    public static class SslRelay
    extends SslListener {
        InetAddrPort _addr;
        File nukeDirOrFile;

        SslRelay(InetAddrPort addr) {
            this._addr = addr;
        }

        public void setNukeDirOrFile(File nukeDirOrFile) {
            this.nukeDirOrFile = nukeDirOrFile;
        }

        @Override
        protected void customizeRequest(Socket socket, HttpRequest request) {
            super.customizeRequest(socket, request);
            URI uri = request.getURI();
            request.setURI(new URI("https://" + this._addr.getHost() + ":" + this._addr.getPort() + uri.toString()));
        }

        @Override
        public void stop() throws InterruptedException {
            super.stop();
            if (this.nukeDirOrFile != null) {
                if (this.nukeDirOrFile.isDirectory()) {
                    LauncherUtils.recursivelyDeleteDir((File)this.nukeDirOrFile);
                } else {
                    this.nukeDirOrFile.delete();
                }
            }
        }
    }
}

