/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.Sleeper;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.InternetExplorerLocator;
import org.openqa.selenium.os.WindowsProcessGroup;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;

public class InternetExplorerCustomProxyLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(InternetExplorerCustomProxyLauncher.class.getName());
    private String exe;
    private String[] args;
    private BrowserInstallation browserInstallation;
    private WindowsProcessGroup process;
    protected boolean customPACappropriate = true;
    protected WindowsProxyManager wpm;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;

    public InternetExplorerCustomProxyLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("iexplore", browserLaunchLocation, (BrowserLocator)new InternetExplorerLocator()));
    }

    public InternetExplorerCustomProxyLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        this.browserInstallation = browserInstallation;
        this.wpm = new WindowsProxyManager(true, sessionId, this.getPort(), this.getPort());
    }

    protected void changeRegistrySettings() {
        this.wpm.changeRegistrySettings(this.browserConfigurationOptions);
    }

    @Override
    public void launch(String url) {
        try {
            this.setupSystem(url);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        log.info("Launching Internet Explorer...");
        this.process = new WindowsProcessGroup(this.exe, this.args);
        this.process.executeAsync();
    }

    private void setupSystem(String url) throws IOException {
        if (WindowsUtils.thisIsWindows()) {
            if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
                this.setupSystemProxy();
            }
            this.exe = this.browserInstallation.launcherFilePath();
            this.args = new String[]{"-new", url};
        } else {
            this.args = new String[]{url};
        }
    }

    public void close() {
        if (WindowsUtils.thisIsWindows() && !this.browserConfigurationOptions.is("honorSystemProxy")) {
            try {
                this.restoreSystemProxy();
            }
            catch (RuntimeException e) {
                log.warning("Unable to restore original system proxy settings");
            }
        }
        if (this.process == null) {
            return;
        }
        if (this.browserConfigurationOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName((String)"iexplore.exe");
        }
        this.process.destroy();
    }

    private void restoreSystemProxy() {
        this.wpm.restoreRegistrySettings(this.browserConfigurationOptions.is("ensureCleanSession"));
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(BrowserOptions.newBrowserOptions(), new RemoteControlConfiguration(), "CUSTIE", (String)null);
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        Sleeper.sleepTight((long)(seconds * 1000));
        l.close();
        System.out.println("He's dead now, right?");
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }

    private void setupSystemProxy() {
        this.wpm.backupRegistrySettings();
        this.changeRegistrySettings();
    }
}

