/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.BasicAuthenticator;
import org.openqa.jetty.http.ClientCertAuthenticator;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.handler.AbstractHttpHandler;
import org.openqa.jetty.log.LogFactory;

public class SecurityHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(SecurityHandler.class);
    private String _authMethod = "BASIC";

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted() && this._authMethod != null && !this._authMethod.equals(method)) {
            throw new IllegalStateException("RestishHandler started");
        }
        this._authMethod = method;
    }

    public void start() throws Exception {
        if (this.getHttpContext().getAuthenticator() == null) {
            if ("BASIC".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new BasicAuthenticator());
            } else if ("CLIENT_CERT".equalsIgnoreCase(this._authMethod)) {
                this.getHttpContext().setAuthenticator(new ClientCertAuthenticator());
            } else {
                log.warn((Object)("Unknown Authentication method:" + this._authMethod));
            }
        }
        super.start();
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        this.getHttpContext().checkSecurityConstraints(pathInContext, request, response);
    }
}

