/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRequest
extends SeleniumBasedRequest {
    public WebDriverRequest(HttpServletRequest httpServletRequest, Registry registry) {
        super(httpServletRequest, registry);
    }

    @Override
    public RequestType extractRequestType() {
        if ("/session".equals(this.getPathInfo())) {
            return RequestType.START_SESSION;
        }
        if (this.getMethod().equalsIgnoreCase("DELETE")) {
            ExternalSessionKey externalKey = ExternalSessionKey.fromWebDriverRequest(this.getPathInfo());
            if (this.getPathInfo().endsWith("/session/" + externalKey.getKey())) {
                return RequestType.STOP_SESSION;
            }
        }
        return RequestType.REGULAR;
    }

    @Override
    public ExternalSessionKey extractSession() {
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String path = this.getPathInfo();
        return ExternalSessionKey.fromWebDriverRequest(path);
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String json = this.getBody();
        HashMap<String, Object> desiredCapability = new HashMap<String, Object>();
        try {
            JSONObject map = new JSONObject(json);
            JSONObject dc = map.getJSONObject("desiredCapabilities");
            Iterator iterator = dc.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = dc.get(key);
                if (value == JSONObject.NULL) {
                    value = null;
                }
                desiredCapability.put(key, value);
            }
        }
        catch (JSONException e) {
            throw new GridException("Cannot extract a capabilities from the request " + json);
        }
        return desiredCapability;
    }

    @Override
    public String getNewSessionRequestedCapability(TestSession session) {
        try {
            JSONObject c = new JSONObject();
            c.put("desiredCapabilities", session.getRequestedCapabilities());
            String content = c.toString();
            return content;
        }
        catch (JSONException e) {
            throw new NewSessionException("Error with the request " + e.getMessage(), e);
        }
    }
}

