/*
 * Decompiled with CFR 0.152.
 */
package cybervillains.ca;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateCreator {
    private static final HashSet<String> clientCertOidsNeverToCopy = new HashSet();
    private static final HashSet<String> clientCertDefaultOidsNotToCopy = new HashSet();
    public static final String KEYGEN_ALGO = "RSA";
    public static final String SIGN_ALGO = "SHA1withRSA";
    public static final String OID_SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String OID_AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String OID_ISSUER_ALTERNATIVE_NAME = "2.5.29.8";
    public static final String OID_ISSUER_ALTERNATIVE_NAME_2 = "2.5.29.18";
    public static final String OID_CRL_DISTRIBUTION_POINT = "2.5.28.31";
    public static final String OID_AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    public static final String OID_ID_AD_CAISSUERS = "1.3.6.1.5.5.7.48.2";

    public static X509Certificate generateStdSSLServerCertificate(PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey, String subject, String certificateRevocationListPath) throws CertificateParsingException, SignatureException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSubjectDN(new X500Principal(subject));
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.setPublicKey(newPubKey);
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 155520000000L));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 31104000000L));
        v3CertGen.setIssuerDN(caCert.getSubjectX500Principal());
        v3CertGen.setSerialNumber(new BigInteger(Long.toString(System.currentTimeMillis())));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(newPubKey));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        DERSequence typicalSSLServerExtendedKeyUsages = new DERSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.3.6.1.5.5.7.3.1"), new DERObjectIdentifier("1.3.6.1.5.5.7.3.2"), new DERObjectIdentifier("2.16.840.1.113730.4.1"), new DERObjectIdentifier("1.3.6.1.4.1.311.10.3.3")});
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.ExtendedKeyUsage, false, (ASN1Encodable)typicalSSLServerExtendedKeyUsages);
        if (certificateRevocationListPath != null) {
            DistributionPoint crl = new DistributionPoint(new DistributionPointName(0, (ASN1Encodable)new GeneralName(6, certificateRevocationListPath)), null, null);
            v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.CRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(new DistributionPoint[]{crl}));
        }
        X509Certificate cert = v3CertGen.generate(caPrivateKey, "BC");
        return cert;
    }

    public static X509Certificate mitmDuplicateCertificate(X509Certificate originalCert, PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey, Set<String> extensionOidsNotToCopy) throws CertificateParsingException, SignatureException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        Set<String> nonCritExs;
        if (extensionOidsNotToCopy == null) {
            extensionOidsNotToCopy = new HashSet<String>();
        }
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSubjectDN(originalCert.getSubjectX500Principal());
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.setPublicKey(newPubKey);
        v3CertGen.setNotAfter(originalCert.getNotAfter());
        v3CertGen.setNotBefore(originalCert.getNotBefore());
        v3CertGen.setIssuerDN(caCert.getSubjectX500Principal());
        v3CertGen.setSerialNumber(originalCert.getSerialNumber());
        Set<String> critExts = originalCert.getCriticalExtensionOIDs();
        if (critExts != null) {
            for (String oid : critExts) {
                if (clientCertOidsNeverToCopy.contains(oid) || extensionOidsNotToCopy.contains(oid)) continue;
                v3CertGen.copyAndAddExtension(new DERObjectIdentifier(oid), true, originalCert);
            }
        }
        if ((nonCritExs = originalCert.getNonCriticalExtensionOIDs()) != null) {
            for (String oid : nonCritExs) {
                if (clientCertOidsNeverToCopy.contains(oid) || extensionOidsNotToCopy.contains(oid)) continue;
                v3CertGen.copyAndAddExtension(new DERObjectIdentifier(oid), false, originalCert);
            }
        }
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(newPubKey));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifierStructure(caCert.getPublicKey()));
        X509Certificate cert = v3CertGen.generate(caPrivateKey, "BC");
        return cert;
    }

    public static X509Certificate mitmDuplicateCertificate(X509Certificate originalCert, PublicKey newPubKey, X509Certificate caCert, PrivateKey caPrivateKey) throws CertificateParsingException, SignatureException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        return CertificateCreator.mitmDuplicateCertificate(originalCert, newPubKey, caCert, caPrivateKey, clientCertDefaultOidsNotToCopy);
    }

    public static X509Certificate createTypicalMasterCert(KeyPair keyPair) throws SignatureException, InvalidKeyException, SecurityException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        X509Principal issuer = new X509Principal("O=CyberVillians.com,OU=CyberVillians Certification Authority,C=US");
        v3CertGen.setSerialNumber(BigInteger.valueOf(1L));
        v3CertGen.setIssuerDN((X509Name)issuer);
        v3CertGen.setSubjectDN((X509Name)issuer);
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 31104000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 622080000000L));
        v3CertGen.setPublicKey(keyPair.getPublic());
        v3CertGen.setSignatureAlgorithm(SIGN_ALGO);
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(keyPair.getPublic()));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.KeyUsage, false, (ASN1Encodable)new KeyUsage(6));
        DERSequence typicalCAExtendedKeyUsages = new DERSequence(new ASN1Encodable[]{new DERObjectIdentifier("1.3.6.1.5.5.7.3.1"), new DERObjectIdentifier("1.3.6.1.5.5.7.3.9"), new DERObjectIdentifier("2.16.840.1.113733.1.8.1")});
        v3CertGen.addExtension((DERObjectIdentifier)X509Extensions.ExtendedKeyUsage, false, (ASN1Encodable)typicalCAExtendedKeyUsages);
        X509Certificate cert = v3CertGen.generate(keyPair.getPrivate(), "BC");
        cert.checkValidity(new Date());
        cert.verify(keyPair.getPublic());
        return cert;
    }

    static {
        clientCertOidsNeverToCopy.add(OID_SUBJECT_KEY_IDENTIFIER);
        clientCertOidsNeverToCopy.add(OID_AUTHORITY_KEY_IDENTIFIER);
        clientCertDefaultOidsNotToCopy.add(OID_ISSUER_ALTERNATIVE_NAME);
        clientCertDefaultOidsNotToCopy.add(OID_ISSUER_ALTERNATIVE_NAME_2);
        clientCertDefaultOidsNotToCopy.add(OID_CRL_DISTRIBUTION_POINT);
        clientCertDefaultOidsNotToCopy.add(OID_AUTHORITY_INFO_ACCESS);
    }
}

