/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.io.File;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.ResponseAwareWebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadFile
extends ResponseAwareWebDriverHandler
implements JsonParametersAware {
    private String file;

    public UploadFile(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        TemporaryFilesystem tempfs = this.getSession().getTemporaryFileSystem();
        File tempDir = tempfs.createTempDir("upload", "file");
        new Zip().unzip(this.file, tempDir);
        File[] allFiles = tempDir.listFiles();
        if (allFiles.length != 1) {
            throw new WebDriverException("Expected there to be only 1 file. There were: " + allFiles.length);
        }
        this.response.setValue((Object)allFiles[0].getAbsolutePath());
        return ResultType.SUCCESS;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.file = (String)allParameters.get("file");
    }
}

