/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.selenium.remote.internal.HttpClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSlot {
    private static final Logger log = Logger.getLogger(TestSlot.class.getName());
    private final Map<String, Object> capabilities;
    private final RemoteProxy proxy;
    private final SeleniumProtocol protocol;
    private final String path;
    private final CapabilityMatcher matcher;
    private volatile TestSession currentSession;
    private final Lock lock = new ReentrantLock();
    volatile boolean beingReleased = false;
    private boolean showWarning = false;

    public TestSlot(RemoteProxy proxy, SeleniumProtocol protocol, String path, Map<String, Object> capabilities) {
        this.proxy = proxy;
        this.protocol = protocol;
        this.path = path;
        CapabilityMatcher c = proxy.getCapabilityHelper();
        if (c == null) {
            throw new InvalidParameterException("the proxy needs to have a valid capabilityMatcher to support have some testslots attached to it");
        }
        this.matcher = proxy.getCapabilityHelper();
        this.capabilities = capabilities;
    }

    public Map<String, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public RemoteProxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        block5: {
            TestSession session;
            block4: {
                try {
                    this.lock.lock();
                    if (this.currentSession == null) break block4;
                    TestSession testSession = null;
                    Object var5_5 = null;
                    this.lock.unlock();
                    return testSession;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            if (!this.matches(desiredCapabilities)) break block5;
            this.currentSession = session = new TestSession(this, desiredCapabilities);
            TestSession testSession = session;
            Object var5_6 = null;
            this.lock.unlock();
            return testSession;
        }
        TestSession testSession = null;
        Object var5_7 = null;
        this.lock.unlock();
        return testSession;
    }

    public SeleniumProtocol getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    boolean matches(Map<String, Object> desiredCapabilities) {
        return this.matcher.matches(this.capabilities, desiredCapabilities);
    }

    public TestSession getSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startReleaseProcess() {
        block3: {
            try {
                this.lock.lock();
                if (!this.beingReleased) break block3;
                boolean bl = false;
                Object var3_3 = null;
                this.lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        this.beingReleased = true;
        boolean bl = true;
        Object var3_4 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishReleaseProcess() {
        try {
            this.lock.lock();
            this.currentSession = null;
            this.beingReleased = false;
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _release() {
        if (this.currentSession == null) {
            return;
        }
        boolean okToContinue = this.startReleaseProcess();
        if (!okToContinue) {
            return;
        }
        try {
            if (this.proxy instanceof TestSessionListener) {
                if (this.showWarning && this.proxy.getMaxNumberOfConcurrentTestSessions() != 1) {
                    log.warning("WARNING : using a afterSession on a proxy that can support multiple tests is risky.");
                    this.showWarning = false;
                }
                ((TestSessionListener)((Object)this.proxy)).afterSession(this.currentSession);
            }
        }
        catch (Throwable t) {
            log.severe("Error running afterSession for " + this.currentSession + " the test slot is now dead.");
            t.printStackTrace();
            return;
        }
        String internalKey = this.currentSession == null ? null : this.currentSession.getInternalKey();
        try {
            this.proxy.getRegistry().getLock().lock();
            this.finishReleaseProcess();
            this.proxy.getRegistry().release(internalKey);
            Object var4_4 = null;
            this.proxy.getRegistry().getLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.proxy.getRegistry().getLock().unlock();
            throw throwable;
        }
    }

    public void forceRelease() {
        if (this.currentSession == null) {
            return;
        }
        String internalKey = this.currentSession.getInternalKey();
        this.currentSession = null;
        this.proxy.getRegistry().release(internalKey);
        this.beingReleased = false;
    }

    public void release() {
        new Thread(new Runnable(){

            public void run() {
                TestSlot.this._release();
            }
        }).start();
    }

    public String toString() {
        return this.currentSession == null ? "no session" : this.currentSession.toString();
    }

    public HttpClientFactory getHttpClientFactory() {
        return this.getProxy().getHttpClientFactory();
    }

    public URL getRemoteURL() {
        String u = this.getProxy().getRemoteHost() + this.getPath();
        try {
            URL res = new URL(u);
            return res;
        }
        catch (MalformedURLException e) {
            throw new GridException("Configuration error for the node." + u + " isn't a valid URL");
        }
    }
}

